/*
 * Decompiled with CFR 0.152.
 */
package de.codesourcery.versiontracker.common;

import de.codesourcery.versiontracker.common.BinarySerializer;
import de.codesourcery.versiontracker.common.ClientVersion;
import de.codesourcery.versiontracker.common.QueryRequest;
import de.codesourcery.versiontracker.common.server.SerializationFormat;
import java.io.IOException;
import org.apache.commons.lang3.Validate;

public abstract class APIRequest {
    public ClientVersion clientVersion;
    public final Command command;

    public APIRequest(Command cmd) {
        Validate.notNull((Object)((Object)cmd), (String)"cmd must not be null", (Object[])new Object[0]);
        this.command = cmd;
    }

    public APIRequest(Command cmd, ClientVersion clientVersion) {
        this(cmd);
        this.clientVersion = clientVersion;
    }

    public final void serialize(BinarySerializer serializer) throws IOException {
        serializer.writeString(this.clientVersion.versionString);
        serializer.writeString(this.command.text);
        this.doSerialize(serializer, this.clientVersion.serializationFormat);
    }

    protected abstract void doSerialize(BinarySerializer var1, SerializationFormat var2) throws IOException;

    public static APIRequest deserialize(BinarySerializer serializer) throws IOException {
        String version = serializer.readString();
        ClientVersion actualVersion = ClientVersion.fromVersionNumber(version);
        Command cmd = Command.fromString(serializer.readString());
        switch (cmd) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case QUERY: 
        }
        return QueryRequest.doDeserialize(serializer, actualVersion);
    }

    public static enum Command {
        QUERY("query");

        public final String text;

        private Command(String text) {
            this.text = text;
        }

        public static Command fromString(String s) {
            for (Command v : Command.values()) {
                if (!v.text.equals(s)) continue;
                return v;
            }
            throw new IllegalArgumentException("Unknown command '" + s + "'");
        }
    }
}

