/*
 * Decompiled with CFR 0.152.
 */
package de.codesourcery.versiontracker.client.api;

import de.codesourcery.versiontracker.common.Artifact;
import de.codesourcery.versiontracker.common.ArtifactResponse;
import de.codesourcery.versiontracker.common.Blacklist;
import de.codesourcery.versiontracker.common.ClientVersion;
import java.io.IOException;
import java.util.List;

public interface IAPIClient
extends AutoCloseable {
    public static final ClientVersion CLIENT_VERSION = ClientVersion.latest();

    public static byte[] prependProtocolIdentifier(byte[] input, Protocol protocol) {
        byte[] tmp = new byte[input.length + 1];
        tmp[0] = protocol.id;
        int readPtr = 0;
        int writePtr = 1;
        int len = input.length;
        while (readPtr < len) {
            tmp[writePtr] = input[readPtr];
            ++readPtr;
            ++writePtr;
        }
        return tmp;
    }

    public List<ArtifactResponse> query(List<Artifact> var1, Blacklist var2) throws IOException;

    public void setDebugMode(boolean var1);

    public static enum Protocol {
        JSON(-85, "application/json"),
        BINARY(-70, "application/octet-stream");

        public final byte id;
        public final String mimeType;

        private Protocol(byte id, String mimeType) {
            this.id = id;
            this.mimeType = mimeType;
        }

        public static Protocol fromByte(byte id) {
            if (id == Protocol.JSON.id) {
                return JSON;
            }
            if (id == Protocol.BINARY.id) {
                return BINARY;
            }
            throw new IllegalArgumentException("Unsupported protocol ID : 0x" + Integer.toHexString(id & 0xFF));
        }
    }
}

