/*
 * Decompiled with CFR 0.152.
 */
package de.clusterfreak.ClusterCore;

import de.clusterfreak.ClusterCore.FuzzyCMeans;
import de.clusterfreak.ClusterCore.Point2D;
import java.util.Vector;

public class PossibilisticCMeans {
    private final int cluster;
    private static final int m = 2;
    private double e = 1.0E-7;
    private final double[][] object;
    private double[][] vi;
    private double[][] viPath;
    private final double[] ni;
    private int repeat;
    private static double[][] getMik;

    public PossibilisticCMeans(double[][] object, int clusterCount, int repeat) {
        this.object = object;
        this.cluster = clusterCount;
        this.vi = new double[this.cluster][2];
        this.ni = new double[this.cluster];
        this.repeat = repeat;
    }

    public PossibilisticCMeans(double[][] object, int clusterCount, int repeat, double e) {
        this.object = object;
        this.cluster = clusterCount;
        this.vi = new double[this.cluster][2];
        this.ni = new double[this.cluster];
        this.repeat = repeat;
        this.e = e;
    }

    public double[][] determineClusterCenters(boolean random, boolean returnPath) {
        double[][] getViPath;
        Vector<Point2D> viPathRec = new Vector<Point2D>();
        FuzzyCMeans fcm = this.e == 1.0E-7 ? new FuzzyCMeans(this.object, this.cluster) : new FuzzyCMeans(this.object, this.cluster, this.e);
        for (double[] doubles : getViPath = fcm.determineClusterCenters(random, true)) {
            viPathRec.add(new Point2D(doubles[0], doubles[1]));
        }
        this.vi = fcm.getVi();
        double[][] mik = fcm.getMik();
        do {
            double euclideanDistance;
            --this.repeat;
            boolean ni_calc = true;
            do {
                int k;
                for (int k2 = 0; k2 < this.vi.length; ++k2) {
                    double mikm0 = 0.0;
                    double mikm1 = 0.0;
                    double mikms = 0.0;
                    for (int i = 0; i < mik.length; ++i) {
                        double mikm = Math.pow(mik[i][k2], 2.0);
                        mikm0 += mikm * this.object[i][0];
                        mikm1 += mikm * this.object[i][1];
                        mikms += mikm;
                    }
                    this.vi[k2][0] = mikm0 / mikms;
                    this.vi[k2][1] = mikm1 / mikms;
                }
                if (returnPath) {
                    for (double[] doubles : this.vi) {
                        viPathRec.add(new Point2D(doubles[0], doubles[1]));
                    }
                }
                double[][] mik_before = new double[mik.length][this.cluster];
                double[] miks = new double[this.vi.length];
                if (ni_calc) {
                    int i;
                    for (i = 0; i < this.vi.length; ++i) {
                        this.ni[i] = 0.0;
                        miks[i] = 0.0;
                    }
                    for (i = 0; i < mik.length; ++i) {
                        for (int k3 = 0; k3 < this.vi.length; ++k3) {
                            double dik = Math.sqrt(Math.pow(this.object[i][0] - this.vi[k3][0], 2.0) + Math.pow(this.object[i][1] - this.vi[k3][1], 2.0));
                            int n = k3;
                            this.ni[n] = this.ni[n] + Math.pow(Math.pow(mik[i][k3], 2.0), 2.0) * Math.pow(dik, 2.0);
                            int n2 = k3;
                            miks[n2] = miks[n2] + Math.pow(mik[i][k3], 2.0);
                        }
                    }
                    for (i = 0; i < this.vi.length; ++i) {
                        int n = i;
                        this.ni[n] = this.ni[n] / miks[i];
                    }
                    ni_calc = false;
                }
                for (k = 0; k < this.vi.length; ++k) {
                    for (int i = 0; i < mik.length; ++i) {
                        mik_before[i][k] = mik[i][k];
                        mik[i][k] = 1.0 / (1.0 + Math.pow(Math.sqrt(Math.pow(this.object[i][0] - this.vi[k][0], 2.0) + Math.pow(this.object[i][1] - this.vi[k][1], 2.0)), 2.0) / this.ni[k]);
                        if (!Double.isNaN(mik[i][k])) continue;
                        mik[i][k] = 1.0;
                    }
                }
                euclideanDistance = 0.0;
                for (k = 0; k < this.vi.length; ++k) {
                    for (int i = 0; i < mik.length; ++i) {
                        euclideanDistance += Math.pow(mik[i][k] - mik_before[i][k], 2.0);
                    }
                }
            } while ((euclideanDistance = Math.sqrt(euclideanDistance)) >= this.e);
        } while (this.repeat > 0);
        getMik = mik;
        if (returnPath) {
            double[][] viPathCut = new double[viPathRec.size()][2];
            for (int k = 0; k < viPathCut.length; ++k) {
                Point2D cut = (Point2D)viPathRec.elementAt(k);
                viPathCut[k][0] = cut.x;
                viPathCut[k][1] = cut.y;
            }
            this.setViPath(viPathCut);
        }
        return this.vi;
    }

    public double[][] getMik() {
        return getMik;
    }

    public static void setMik(double[][] setMik) {
        getMik = setMik;
    }

    public double[][] getVi() {
        return this.vi;
    }

    private void setViPath(double[][] setViPath) {
        this.viPath = setViPath;
    }

    public double[][] getViPath() {
        return this.viPath;
    }
}

