/*
 * Decompiled with CFR 0.152.
 */
package de.clusterfreak.ClusterCore;

import de.clusterfreak.ClusterCore.Point2D;
import java.util.Vector;

public class FuzzyCMeans {
    private int cluster = 2;
    private static final int m = 2;
    private double e = 1.0E-7;
    private double[][] object;
    private double[][] vi;
    private double[][] viPath;
    private static double[][] getMik;
    private static boolean path;

    public FuzzyCMeans(double[][] object, int clusterCount) {
        this.object = object;
        this.cluster = clusterCount;
        this.vi = new double[this.cluster][2];
    }

    public FuzzyCMeans(double[][] object, int clusterCount, double e) {
        this.object = object;
        this.cluster = clusterCount;
        this.vi = new double[this.cluster][2];
        this.e = e;
    }

    public double[][] determineClusterCenters(boolean random, boolean returnPath) {
        double euclideanDistance;
        int k;
        double[][] mik = new double[this.object.length][this.cluster];
        path = returnPath;
        Vector<Point2D> viPathRec = new Vector<Point2D>();
        if (random) {
            for (int i = 0; i < mik.length; ++i) {
                for (k = 0; k < this.cluster; ++k) {
                    mik[i][k] = Math.random();
                }
            }
        } else {
            int s = 0;
            for (int i = 0; i < mik.length; ++i) {
                for (int k2 = 0; k2 < this.cluster; ++k2) {
                    mik[i][k2] = k2 == s ? 1.0 : 0.0;
                }
                if (++s != this.cluster) continue;
                s = 0;
            }
        }
        do {
            int i;
            int k3;
            for (k3 = 0; k3 < this.vi.length; ++k3) {
                double mikm = 0.0;
                double mikm0 = 0.0;
                double mikm1 = 0.0;
                double mikms = 0.0;
                for (int i2 = 0; i2 < mik.length; ++i2) {
                    mikm = Math.pow(mik[i2][k3], 2.0);
                    mikm0 += mikm * this.object[i2][0];
                    mikm1 += mikm * this.object[i2][1];
                    mikms += mikm;
                }
                this.vi[k3][0] = mikm0 / mikms;
                this.vi[k3][1] = mikm1 / mikms;
            }
            if (path) {
                for (k3 = 0; k3 < this.vi.length; ++k3) {
                    viPathRec.add(new Point2D(this.vi[k3][0], this.vi[k3][1]));
                }
            }
            double[][] mik_before = new double[mik.length][this.cluster];
            for (k = 0; k < this.vi.length; ++k) {
                for (i = 0; i < mik.length; ++i) {
                    double dik = 0.0;
                    mik_before[i][k] = mik[i][k];
                    for (int j = 0; j < this.vi.length; ++j) {
                        dik += Math.pow(1.0 / Math.sqrt(Math.pow(this.object[i][0] - this.vi[j][0], 2.0) + Math.pow(this.object[i][1] - this.vi[j][1], 2.0)), 1.0);
                    }
                    mik[i][k] = Math.pow(1.0 / Math.sqrt(Math.pow(this.object[i][0] - this.vi[k][0], 2.0) + Math.pow(this.object[i][1] - this.vi[k][1], 2.0)), 1.0) / dik;
                    if (!Double.isNaN(mik[i][k])) continue;
                    mik[i][k] = 1.0;
                }
            }
            euclideanDistance = 0.0;
            for (k = 0; k < this.vi.length; ++k) {
                for (i = 0; i < mik.length; ++i) {
                    euclideanDistance += Math.pow(mik[i][k] - mik_before[i][k], 2.0);
                }
            }
        } while ((euclideanDistance = Math.sqrt(euclideanDistance)) >= this.e);
        getMik = mik;
        if (path) {
            double[][] viPathCut = new double[viPathRec.size()][2];
            for (k = 0; k < viPathCut.length; ++k) {
                Point2D cut = (Point2D)viPathRec.elementAt(k);
                viPathCut[k][0] = cut.x;
                viPathCut[k][1] = cut.y;
            }
            this.setViPath(viPathCut);
        }
        return this.vi;
    }

    public double[][] getMik() {
        return getMik;
    }

    public static void setMik(double[][] setMik) {
        getMik = setMik;
    }

    public double[][] getVi() {
        return this.vi;
    }

    private void setViPath(double[][] setViPath) {
        this.viPath = setViPath;
    }

    public double[][] getViPath() {
        return this.viPath;
    }

    static {
        path = false;
    }
}

