package de.clued_up.voicecontrols.voicereply;


import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.RemoteInput;
import android.util.Log;

public class ReplyActivity extends Activity
{

    private static final String TAG = "com.cluedup.voicecontrols.voicereply.ReplyActivity";

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);

        Log.d(TAG, "Reply Activity created!");


        Log.d(TAG, "entered text: "+getVoiceReply(getIntent()));

		Intent intent= new Intent();
		intent.setAction(VoiceReplyIntentReceiver.ACTION_VOICE_REPLY);
		intent.putExtra(VoiceReplyIntentReceiver.EXTRA_VOICE_REPLY, getVoiceReply(getIntent()));
		sendBroadcast(intent);



        //we do not need the activity any more
		finish();
	}
	
	private String getVoiceReply(Intent intent)
	{
		Bundle remoteInput = RemoteInput.getResultsFromIntent(intent);
		if (remoteInput != null)
		{
			return remoteInput.getCharSequence(VoiceReplyIntentReceiver.EXTRA_VOICE_REPLY).toString();
		}
		return null; 
	}

}
