package de.clued_up.voicecontrols.voiceform;

import android.os.Bundle;

import de.clued_up.commons.data.VoiceFormResult;


/**
 * Must be implemented and passed to the VoiceFormBuilder
 * Allows to get the results of the VoiceForm
 */
public interface VoiceFormListener
{
	/**
	 * Called when the VoiceForm did not complete successfully, but stopped
	 * @param iErrorCode specifies the reason why the VoiceForm stopped
	 */
	public void onVoiceFormCanceled(int iErrorCode);
	
	/**
	 * Called when the VoiceForm completed successfully.
	 * @param result contains the relevant, entered data. Use convenience functions of VoiceFormResultParser
	 * to access the data within the bundle 
	 */
	public void onVoiceFormCompleted(VoiceFormResult result);
}
