package de.clued_up.voicecontrols.test;

import android.content.Context;
import android.content.Intent;
import android.util.Log;

import de.clued_up.commons.data.VoiceForm;
import de.clued_up.commons.test.VoiceControlTest;
import de.clued_up.commons.test.VoiceControlTestFailedException;
import de.clued_up.voicecontrols.services.VoiceFormService;
import de.clued_up.voicecontrols.voiceform.VoiceFormBuilder;
import de.clued_up.voicecontrols.voiceform.VoiceFormListener;
import de.clued_up.voicecontrols.voicereply.VoiceReplyIntentReceiver;


public class TestVoiceFormBuilder extends VoiceFormBuilder {

    protected static final String TAG = TestVoiceFormBuilder.class.toString();

    protected TestPerformEnquiryReceiver m_PerformEnquiryReceiver;

    public TestVoiceFormBuilder(Context context,
                                String strKey,
                                VoiceForm voiceForm,
                                VoiceFormListener listener,
                                final VoiceControlTest testCase) {

        super(context, strKey, voiceForm, listener);

        m_PerformEnquiryReceiver = new TestPerformEnquiryReceiver() {

            @Override
            protected void onEnquiry(String strEnquiry) {

                Log.d(TAG, "onEnquiry: "+strEnquiry);
                Intent intent= new Intent();
                intent.setAction(VoiceReplyIntentReceiver.ACTION_VOICE_REPLY);

                //get the input from the testcase and put the input into the reply-broadcast
                try {
                    intent.putExtra(VoiceReplyIntentReceiver.EXTRA_VOICE_REPLY,
                            testCase.getTextInput(strEnquiry));
                } catch (VoiceControlTestFailedException e) {
                    e.printStackTrace();
                }
                m_Context.sendBroadcast(intent);


            }
        }.register(m_Context);
    }

    @Override
    protected Class<?> getServiceClass() {
        return TestVoiceFormService.class;
    }

    public void unregister() {
        m_Context.unregisterReceiver(m_PerformEnquiryReceiver);
    }

}
