package de.clued_up.voicecontrols.test;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.util.Log;

public abstract class TestPerformEnquiryReceiver extends BroadcastReceiver
{
	private static final String TAG = "de.clued_up.voicecontrols.test.TestPerformEnquiryReceiver";

    public static final String ACTION_REQUESTINPUT = "de.clued_up.voicecontrols.test.TestVoiceFormService.ACTION_REQUESTINPUT";
    public static final String ENQUIRY = "de.clued_up.voicecontrols.test.TestVoiceFormService.ENQUIRY";

    /** called when an enquiry is received  */
    protected abstract void onEnquiry(String strEnquiry);

	@Override
	public void onReceive(Context context, Intent intent)
	{ 
		Log.d(TAG, "onReceive");
		if (intent.getAction().equals(ACTION_REQUESTINPUT))
		{
            if (intent.hasExtra(TestPerformEnquiryReceiver.ENQUIRY)) {

                onEnquiry(intent.getStringExtra(TestPerformEnquiryReceiver.ENQUIRY));

            }
            else {
                Log.d(TAG, "no enquiry found");

            }

		}
		else {
            Log.d(TAG, "wrong intent action!");
			
		}
	}

	public TestPerformEnquiryReceiver register(Context context)
	{
		final IntentFilter filter = new IntentFilter();
        filter.addAction(TestPerformEnquiryReceiver.ACTION_REQUESTINPUT);

        //for whatever reason: the pending delete intent in the
        //callVoiceControlBackendService does not work, without adding this line?
        //filter.addAction(TestPerformEnquiryReceiver.EXTRA_VOICE_CANCELLED);

        // Registers the receiver so that your service will listen for broadcasts
	    context.registerReceiver(this, filter);

	    return this;
		
	} 
} 
