package de.clued_up.voicecontrols.test;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;

import java.util.ArrayList;
import java.util.Arrays;

import de.clued_up.commons.data.ConceptObject;
import de.clued_up.commons.data.ConceptRelation;
import de.clued_up.commons.data.VoiceFormResult;
import de.clued_up.commons.test.VoiceControlTest;
import de.clued_up.commons.test.VoiceControlTestFailedException;
import de.clued_up.commons.test.cases.*;
import de.clued_up.voicecontrols.R;
import de.clued_up.voicecontrols.services.VoiceFormService;
import de.clued_up.voicecontrols.voiceform.VoiceFormListener;

public class TestActivity extends Activity
{
	protected static final String TAG = TestActivity.class.toString();
	
	protected static final String KEY_FORMSERVICE = "de.clued_up.voicecontrols.TestApplication.KEY_FORMSERVICE";


    private final ArrayList<VoiceControlTest> m_listTestCases =
        new ArrayList<VoiceControlTest>(Arrays.asList(
                new test001_ValidCommand(),
                new test002_InvalidCommandObject(),
                new test003_ValidCommandWithAttributes(),
                new test004_ValidCommandWithTwoAttributes(),
                new test005_ValidActionWithAttribute(),
                new test006_ValidInfinitive(),
                new test007_ValidInfinitive(),
                new test008_ValidDeclarative(),
                new test009_ValidInterrogative(),
                new test010_ValidInterrogativeWithCommand(),
                new test012_IdentifyCommandFromList(),
                new test013_IdentifyAttributesWithCommandObjectAsPreposition(),
                new test014_IdentifyNumberOfCommandObjects(),
                new test015_IdentifyNumberAndUnitOfCommandObjects(),
                new test016_InvalidCommandWithNumberAndUnit(),
                new test017_InfinitiveWithNumberAndUnit(),
                new test018_ActivityWithWrongUnit(),
                new test019_WithEnquiry(),
                new test020_TimeAttributeTwoNumbers(),
                new test021_TimeAttributeTwoNumbersWithTo(),
                new test022_TimeAttributeTwoNumbersWithPast(),
                new test023_DeclarativeWithoutSubject(),
                new test024_NoEnquiryWithNoActivity(),
                new test025_CommandObjectOnly(),
                new test026_AttributeValue(),
                new test027_SingleWord(),
                new test028_SingleWordTwoAttributes(),
                new test029_MultipleAttributeValues(),
                new test030_MultipleAttributeValuesOneOfThree(),
                new test031_MultipleAttributeValuesTwoOfThree(),
                new test032_MultipleAttributeValuesWithOwnPrepositionsAndInvalidValues(),
                new test033_MultipleAttributeValuesWithOwnPrepositions(),
                new test034_AttributeApplicableToObject(),
                new test035_MandatoryAttributeNotApplicableToObject(),
                new test036_AttributeNotApplicableToObject(),
                new test037_NoEnquiryForNotMandatoryAttribute(),
                new test038_AppendedVariation(),
                new test039_PreceedingVariation(),
                new test040_AttributeValueIsCompoundNoun(),
                new test041_InfinitiveWithoutSubject(),
                new test042_SubjectSmallI(),
                new test043_SingleWordDifferenceInCapitalization()
    ));

    private boolean m_bWaitingForTestToComplete = true;
    private int m_iSuccessfulTests = 0;
    private int m_iFailedTests = 0;

    private VoiceControlTest m_testCase;

    private TestVoiceFormBuilder m_TestVoiceFormBuilder;

    @Override
	protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        Log.d(TAG, "Test cases: "+m_listTestCases.size());

        Thread thread = new Thread() {
            @Override
            public void run() {
                for (final VoiceControlTest testCase :m_listTestCases) {

                    new Runnable() {

                        @Override
                        public void run() {
                            runTest(testCase);
                        }

                    }.run();



                    //wait until test is completed
                    while (m_bWaitingForTestToComplete)
                    {
                        try
                        {
                            Thread.sleep(300);
                        }
                        catch (InterruptedException e)
                        {
                            e.printStackTrace();
                        }
                    }

                }

                int sum = m_iSuccessfulTests+m_iFailedTests;
                Log.d(TAG, sum+" completed tests. Successful: "+m_iSuccessfulTests+". Failed: "+m_iFailedTests);

                finish();
            }
        };

        thread.start();


    }


    /*@Override
    public void onDestroy() {

        super.onDestroy();
    }*/

    public void runTest(VoiceControlTest testCase)
    {
        Log.d(TAG, "runTest: "+testCase.getClass().toString());

        m_bWaitingForTestToComplete = true;
        m_testCase = testCase;

        //must be filled, otherwise the form crashes
        m_testCase.getForm()
            .setIconResource(R.drawable.ic_launcher)
            .setLabel("label")
            .setEnquiry("enquiry")
            .setEnquiryAction("enquiry action")
            .setEnquiryActionIconResource(R.drawable.ic_launcher)
            .setBackgroundImageResource(R.drawable.ic_launcher);

        //create a new Voice Form
        m_TestVoiceFormBuilder = new TestVoiceFormBuilder(
                getApplicationContext(),
                KEY_FORMSERVICE,
                m_testCase.getForm(),
                new VoiceFormListener()
                {
                    @Override
                    public void onVoiceFormCanceled(int iErrorCode)
                    {
                        Log.d(TAG, "onVoiceFormCanceled: " + iErrorCode);

                        if (iErrorCode == VoiceFormService.VFE_LIMITEXCEEDED)
                            Log.d(TAG, "unfortunately, you exceeded your limit of requests!");

                        currentTestCompleted();
                    }

                    @Override
                    public void onVoiceFormCompleted(VoiceFormResult result){
                        Log.d(TAG, "onVoiceFormCompleted: "
                                +VoiceFormResult.resultTypeToString(result.getResultType()));

                        if (result.getInputAnalysisResults_Activity() != null) {
                            for (de.clued_up.commons.data.Activity activity :result.getInputAnalysisResults_Activity()) {
                                Log.d(TAG, "activity: "+activity.parseToString());

                                if (activity.getRelated_Objects() != null) {
                                    for (ConceptObject co :activity.getRelated_Objects()) {
                                        Log.d(TAG, "object: "+co.getLemma("null"));
                                    }
                                }

                                if (activity.getRelated_Relations() != null) {
                                    for (ConceptRelation cr :activity.getRelated_Relations()) {
                                        Log.d(TAG, "relation: "+cr.getLemma("null"));
                                    }
                                }
                            }
                        }

                        try {
                            m_testCase.checkResult(result);
                            m_iSuccessfulTests++;

                        } catch (VoiceControlTestFailedException e) {
                            e.printStackTrace();
                            m_iFailedTests++;
                        }

                        currentTestCompleted();

                    }

                },
                testCase

        );

        m_TestVoiceFormBuilder.start();
	}

    private void currentTestCompleted() {
        Log.d(TAG, "currentTestCompleted: unregister Broadcastreceiver!");
        m_TestVoiceFormBuilder.unregister();
        m_bWaitingForTestToComplete = false;
    }

}
