package de.clued_up.voicecontrols.async;

import android.os.AsyncTask;
import android.os.Bundle;
import android.util.Log;


/**
 * The TrackedAsyncTask works with the AsyncTaskTracker that tracks the progress of the task
 * and makes sure that it is finished
 */
public abstract class TrackedAsyncTask extends AsyncTask<Void, Bundle, Boolean>
{
	private static final String TAG = TrackedAsyncTask.class.toString();
	
	
	/** Keys for the bundle that the status receives */
	public static final String KEY_UPDATEMESSAGE = "KEY_UPDATEMESSAGE";
	public static final String KEY_ASYNCTASKSTATUS = "KEY_ASYNCTASKSTATUS";
	
	
	/** defines the different states that a asynctask can be in: the async task is working - unspecified */
	public static final int STATUS_WORKING = 0;
	
	/** defines the different states that a asynctask can be in: the async task is working with the network,
	 * e.g. calling an endpoint */
	public static final int STATUS_NETWORK = 1;
	
	/** defines the different states that a asynctask can be in: the async task is working locally, e.g. on the database */
	public static final int STATUS_LOCAL = 2;
	
	/** defines the different states that a asynctask can be in: the async task is waiting for the user */
	public static final int STATUS_IDLE_USERINPUT = 3;
	
	

	/** tracks the status of the asynctask and handles status messages*/
	final protected de.clued_up.voicecontrols.async.AsyncTaskTracker m_AsyncTaskTracker;
	
	/** used to show toasts to the user*/
	final protected de.clued_up.voicecontrols.async.AsyncTaskToastSupporter m_ToastSupporter;
	
	/** specifies the identifiying Key of the task: there can always be only one task of a key*/
	final protected String m_strKey;
	public String getKey(){return m_strKey;}
	
	/** saves the last status of the asynctask */
	private int m_iStatus = STATUS_WORKING;
	
	/** must implement the abortion of the task, can be called by the AsyncTaskTracker that monitors the tasks */
	public abstract void abortTask();
	
	public TrackedAsyncTask(de.clued_up.voicecontrols.async.AsyncTaskToastSupporter toastSupporter, AsyncTaskTracker tracker, String key)
	{
		m_ToastSupporter = toastSupporter;
		m_AsyncTaskTracker = tracker;
		m_strKey = key;
		
	}
	
	public void showToast(String message)
	{
		if (m_ToastSupporter != null)
			m_ToastSupporter.showToast(message);
	}
	
	public void showToast(int resId)
	{
		if (m_ToastSupporter != null)
			m_ToastSupporter.showToast(resId);
	}
	
	@Override
	protected void onPreExecute()
	{
		super.onPreExecute();
		Log.d(TAG, "onPreExecute");
		m_AsyncTaskTracker.onAsyncTaskStarted(this);
	}
	
	@Override
	protected void onProgressUpdate(Bundle... args)
	{
		//when the message contains a status, update it
		if (args[0] != null && args[0].containsKey(KEY_ASYNCTASKSTATUS))
				m_iStatus = args[0].getInt(KEY_ASYNCTASKSTATUS);
			
		m_AsyncTaskTracker.onAsyncTaskUpdated(this, args[0]);
	} 
	
	
	@Override
	protected void onPostExecute(Boolean success) 
	{
		super.onPostExecute(success);
		Log.d(TAG, "onPostExecute");
		m_AsyncTaskTracker.onAsyncTaskStopped(this);
		
	}
	
	public void publishProgress(int iStatus, String msg)
	{
		Bundle args = new Bundle();
		args.putInt(KEY_ASYNCTASKSTATUS, iStatus);
		args.putString(KEY_UPDATEMESSAGE, msg);
		this.publishProgress(args);
	}
}
