package de.clued_up.voicecontrols.async;


/** takes care about showing and hiding a progress animation that informs the
 * user about what the app currently does asynchronically */
public interface ProgressAnimator
{
	/** starts the progress animation */
	void startProgressAnimation();
	
	/** stops the progress animation */
	void stopProgressAnimation();
	
	/** updates the message displayed during the progress animation */
	void updateAsyncMessage(String message);
	
	/** the progress animator should have access to the async counter that
	 * knows whether there are any ongoing async tasks */
	de.clued_up.voicecontrols.async.AsyncTaskSupporter getAsyncTaskSupporter();
}
