package de.clued_up.voicecontrols;

import java.util.ArrayList;
import java.util.Arrays;

import de.clued_up.commons.data.VoiceAttribute;
import de.clued_up.commons.data.VoiceAttributeResult;
import de.clued_up.commons.data.VoiceForm;
import de.clued_up.commons.data.VoiceFormResult;
import de.clued_up.voicecontrols.services.VoiceFormService;
import de.clued_up.voicecontrols.voiceform.VoiceFormBuilder;
import de.clued_up.voicecontrols.voiceform.VoiceFormListener;

import android.app.Activity;
import android.app.Notification;
import android.os.Bundle;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.NotificationManagerCompat;
import android.util.Log;
import android.widget.Toast;

public class ExampleActivity extends Activity
{
	protected static final String TAG = ExampleActivity.class.toString();
	
	protected static final String KEY_FORMSERVICE = "de.clued_up.voicecontrols.TestApplication.KEY_FORMSERVICE";


    @Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);

		//create a new Voice Form
		new VoiceFormBuilder(getApplicationContext(), KEY_FORMSERVICE,
				new VoiceForm()
					.setIconResource(R.drawable.ic_launcher)
					.setLabel("Delivery Service")
					.setEnquiry("What do you want to order?")
					.setEnquiryAction("Order now")
					.setEnquiryActionIconResource(R.drawable.ic_launcher)
                    .setBackgroundImageResource(R.drawable.ic_launcher)
					//.setActions(new ArrayList<String>(Arrays.asList("have")))
					.setCommandActions(new ArrayList<String>(Arrays.asList("have", "give", "deliver", "get", "order", "want")))
					.setCommandObjects(new ArrayList<String>(Arrays.asList("pizza", "spaghetti", "pasta")))
                    /*.addAttribute(new de.clued_up.commons.data.VoiceAttribute()
                            .setName("Sauce")
                            .setPreposition("with")
                            .setNoOfValues(1)
                            .setEnquiry("What sauce do you want your spaghetti with?")
                            .setEnquiryAction("Specify sauce")
                            .setEnquiryActionIconResource(R.drawable.ic_launcher)
                            .setValueType(VoiceAttribute.VALUETYPE_LIST)
                            .setValues(new ArrayList<String>(Arrays.asList("arrabiata", "bolognese", "napoli")))
                            .setIsMandatory(true))
                   */.addAttribute(new VoiceAttribute()
                            .setName("Topping")
                            .setPreposition("with")
                            .setNoOfValues(2)
                            .setEnquiry("What do you want to have on your pizza?")
                            .setEnquiryAction("Add toppings")
                            .setEnquiryActionIconResource(R.drawable.ic_launcher)
                            .setValueType(VoiceAttribute.VALUETYPE_LIST)
                            .setValues(new ArrayList<String>(Arrays.asList("salami", "cheese", "pepperoni", "anchovi", "mushroom")))
                            .setIsMandatory(true)),
				new VoiceFormListener()
				{

					@Override
					public void onVoiceFormCanceled(int iErrorCode)
					{
						Log.d(TAG, "onVoiceFormCanceled: "+iErrorCode);
						
						if (iErrorCode == VoiceFormService.VFE_LIMITEXCEEDED)
							 Log.d(TAG, "unfortunately, you exceeded your limit of requests!");


                        Toast.makeText(ExampleActivity.this,
                                "onVoiceFormCanceled: "+iErrorCode,
                                Toast.LENGTH_LONG).show();
                    }

                    @Override
                    public void onVoiceFormCompleted(VoiceFormResult result)
                    {
                        Log.d(TAG, "onVoiceFormCompleted: "+result.getResultType());



                        if (result.getResultType() != null &&
                                (result.getResultType() == VoiceFormResult.VFR_COMPLETED ||
                                        result.getResultType() == VoiceFormResult.VFR_MANDATORYCOMPLETED)) {

                            NotificationManagerCompat notificationManager;
                            notificationManager = NotificationManagerCompat.from(ExampleActivity.this);

                            String strText = "sorry, this was an error!";

                            if (result.getEnteredActivity() != null && result.getEnteredActivity().getDirectObject() != null) {

                                String strDirectObject = result.getEnteredActivity().getDirectObject().getLemma("");

                                if (strDirectObject.compareToIgnoreCase("pizza") == 0) {

                                    //get the results of the specific attribute
                                    strText = "You ordered a pizza with ";
                                    boolean bIsFirst = true;
                                    VoiceAttributeResult topping = result.getAttributeResultByName("Topping");
                                    if (topping != null && topping.getResults() != null) {

                                        for (String strResult : topping.getResults()) {
                                            if (!bIsFirst)
                                                strText += " and ";

                                            strText += strResult;
                                            bIsFirst = false;
                                        }

                                    }
                                }

                                if (strDirectObject.compareToIgnoreCase("spaghetti") == 0 ||
                                        strDirectObject.compareToIgnoreCase("pasta") == 0) {

                                    //get the results of the specific attribute
                                    strText = "You ordered "+strDirectObject+" ";
                                    VoiceAttributeResult topping = result.getAttributeResultByName("Sauce");
                                    if (topping != null && topping.getResults() != null) {

                                        for (String strResult : topping.getResults()) {

                                            strText += strResult;
                                            break;
                                        }

                                    }
                                }

                                Notification notification = new NotificationCompat.Builder(ExampleActivity.this)
                                        .setSmallIcon(R.drawable.ic_launcher)
                                        .setContentTitle("Order complete")
                                        .setContentText(strText)
                                        .build();

                                // Issue the notification
                                notificationManager.notify(1, notification);
                            }

                        }
					}
			
				}
		)
        .start();

        finish();
	}

}
