package de.clued_up.voicecontrols.voicereply;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.util.Log;

public abstract class VoiceReplyIntentReceiver extends BroadcastReceiver
{
	private static final String TAG = "com.cluedup.voicecontrols.voicereply.VoiceReplyIntentReceiver";

	/** key for the broadcast receiver to find the voice reply - this broadcast is sent when we have a successful voice reply*/
	public static final String ACTION_VOICE_REPLY = "com.cluedup.voicecontrols.voicereply.VoiceReplyIntentReceiver.ACTION_VOICE_REPLY";

    /** key for the broadcast receiver to find the voice reply - this broadcast is sent when getting the reply is cancelled */
	public static final String EXTRA_VOICE_CANCELLED = "com.cluedup.voicecontrols.voicereply.VoiceReplyIntentReceiver.EXTRA_VOICE_CANCELLED";


	/** key for the storage of the actual voice reply */
	public static final String EXTRA_VOICE_REPLY = "com.cluedup.voicecontrols.voicereply.VoiceReplyIntentReceiver.EXTRA_VOICE_REPLY";
	
	/** listener who needs to be informed of a reply*/
	private VoiceReplyListener m_VoiceReplyListener;
	
	/** is called when the Service needs to be stopped */
	protected abstract void stopService();
	
	public void setVoiceReplyListener(VoiceReplyListener listener)
	{
		m_VoiceReplyListener = listener;
		
	}
	
	@Override
	public void onReceive(Context context, Intent intent)
	{ 
		Log.d(TAG, "onReceive");
		if (intent.getAction().equals(ACTION_VOICE_REPLY))
		{
            if (intent.hasExtra(VoiceReplyIntentReceiver.EXTRA_VOICE_REPLY) &&
                    !intent.hasExtra(VoiceReplyIntentReceiver.EXTRA_VOICE_CANCELLED)) {

                String replyMessage = intent.getStringExtra(VoiceReplyIntentReceiver.EXTRA_VOICE_REPLY);

                Log.d(TAG, "entered text: "+replyMessage);

                if (m_VoiceReplyListener != null)
                    m_VoiceReplyListener.onVoiceReplyReceived(replyMessage);
            }
            else {
                Log.d(TAG, "onVoiceCancelled");

                m_VoiceReplyListener.onVoiceReplyFailed();

                //when the user dismisses the notification, we can stop the service
                stopService();
            }

		}
		else {
            Log.d(TAG, "wrong intent action!");
			
		}
	}

	public VoiceReplyIntentReceiver register(Context context)
	{
		final IntentFilter filter = new IntentFilter();
        filter.addAction(VoiceReplyIntentReceiver.ACTION_VOICE_REPLY);

        //for whatever reason: the pending delete intent in the
        //callVoiceControlBackendService does not work, without adding this line?
        filter.addAction(VoiceReplyIntentReceiver.EXTRA_VOICE_CANCELLED);

        // Registers the receiver so that your service will listen for broadcasts
	    context.registerReceiver(this, filter);

	    return this;
		
	} 
} 
