package de.clued_up.voicecontrols;

import java.util.ArrayList;
import java.util.Arrays;

import de.clued_up.commons.data.VoiceAttribute;
import de.clued_up.commons.data.VoiceForm;
import de.clued_up.voicecontrols.services.VoiceFormService;
import de.clued_up.voicecontrols.voiceform.VoiceFormBuilder;
import de.clued_up.voicecontrols.voiceform.VoiceFormListener;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.widget.Toast;

public class TestActivity extends Activity
{
	protected static final String TAG = TestActivity.class.toString();
	
	protected static final String KEY_FORMSERVICE = "de.clued_up.voicecontrols.TestApplication.KEY_FORMSERVICE";


    @Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);

		//create a new Voice Form
		new VoiceFormBuilder(getApplicationContext(), KEY_FORMSERVICE,
				new VoiceForm()
					.setIconResource(R.drawable.ic_launcher)
					.setLabel("Delivery Service")
					.setEnquiry("What do you want to order?")
					.setEnquiryAction("Order now")
					.setEnquiryActionIconResource(R.drawable.ic_launcher)
                    .setBackgroundImageResource(R.drawable.ic_launcher)
					.setActions(new ArrayList<String>(Arrays.asList("have")))
					.setCommandActions(new ArrayList<String>(Arrays.asList("give", "deliver", "get", "order")))
					.setCommandObjects(new ArrayList<String>(Arrays.asList("pizza", "spaghetti", "pasta")))
                    .addAttribute(new de.clued_up.commons.data.VoiceAttribute()
                            .setName("Sauce")
                            .setPreposition("with")
                            .setNoOfValues(2)
                            .setEnquiry("What sauce do you want your spaghetti with?")
                            .setEnquiryAction("Specify sauce")
                            .setEnquiryActionIconResource(R.drawable.ic_launcher)
                            .setValueType(VoiceAttribute.VALUETYPE_LIST)
                            .setValues(new ArrayList<String>(Arrays.asList("arrabiata", "bolognese", "napoli")))
                            .setIsMandatory(true))
                    .addAttribute(new VoiceAttribute()
                            .setName("Topping")
                            .setPreposition("with")
                            .setNoOfValues(2)
                            .setEnquiry("What do you want to have on your pizza?")
                            .setEnquiryAction("Add toppings")
                            .setEnquiryActionIconResource(R.drawable.ic_launcher)
                            .setValueType(VoiceAttribute.VALUETYPE_LIST)
                            .setValues(new ArrayList<String>(Arrays.asList("salami", "cheese", "pepperoni", "anchovi", "mushroom")))
                            .setIsMandatory(true)),
				new VoiceFormListener()
				{

					@Override
					public void onVoiceFormCanceled(int iErrorCode)
					{
						Log.d(TAG, "onVoiceFormCanceled: "+iErrorCode);
						
						if (iErrorCode == VoiceFormService.VFE_LIMITEXCEEDED)
							Log.d(TAG, "unfortunately, you exceeded your limit of requests!");


                        Toast.makeText(TestActivity.this,
                                "onVoiceFormCanceled: "+iErrorCode,
                                Toast.LENGTH_LONG).show();
					}

					@Override
					public void onVoiceFormCompleted(Bundle result)
					{
						Log.d(TAG, "onVoiceFormCompleted");

                        Toast.makeText(TestActivity.this,
                                "onVoiceFormCompleted",
                                Toast.LENGTH_LONG).show();

						/*VoiceFormResultBundle voiceFormResult = VoiceFormResultBundle.fromBundle(result);
						
						VoiceAttributeResultBundle resultTopping = voiceFormResult.getAttributeResultByName("Topping");
						List<String> listOfToppings = resultTopping.getResults();

						
						Log.d(TAG, "result: "+voiceFormResult.getResultType());
						Log.d(TAG, "enteredActivity: "+voiceFormResult.getEnteredActivity());
						*/
						
					}
			
				}
		)
        .start();

        finish();
	}

}
