package de.clued_up.voicecontrols.data;

import java.util.ArrayList;
import java.util.List;
import android.os.Bundle;

import de.clued_up.voicecontrols.backend.apiVoiceForm.model.VoiceFormResultBean;

public class VoiceFormResultBundle
{
	/** must match the data in the VoiceFormResult */
	/** the voice form was successfully completed, and all fields were filled */
	public static final int VFR_COMPLETED = 0;
	  
	/** the voice form was successfully completed, but some fields may not be filled that are not mandatory */
	public static final int VFR_MANDATORYCOMPLETED = 1;
	
	/** the voice form was not completed, at least one mandatory field is missing */
	public static final int VFR_INCOMPLETE = 2;
	
	/** the voice form was not completed, no valid command was issued */
	public static final int VFR_INVALIDCOMMAND = 3;

    /** !!! VALUES BETWEEN 10 and 20 are reserved for administrative reasons, e.g. limit of requests exceeded */
    /** the voice form was not completed, no valid command was issued or at least one mandatory field is missing */
    public static final int  VFR_REQUESTLIMITEXCEEDED = 10;

	private static final String KEY_RESULTTYPE = "com.cluedup.voicecontrols.data.VoiceFormResultBundle.KEY_RESULTTYPE";
	private static final String KEY_ENTEREDACTIVITY = "com.cluedup.voicecontrols.data.VoiceFormResultBundle.KEY_ENTEREDACTIVITY";
	private static final String KEY_REQUESTEDNUMBER = "com.cluedup.voicecontrols.data.VoiceFormResultBundle.KEY_REQUESTEDNUMBER";
	private static final String KEY_REQUESTEDUNIT = "com.cluedup.voicecontrols.data.VoiceFormResultBundle.KEY_REQUESTEDUNIT";
	private static final String KEY_ATTRIBUTERESULTS = "com.cluedup.voicecontrols.data.VoiceFormResultBundle.KEY_ATTRIBUTERESULTS";

	private Integer m_iResultType;
    public Integer getResultType() {return m_iResultType;}
    public VoiceFormResultBundle setResultType(int iResultType) {m_iResultType = iResultType; return this;}
	
    private String m_strEnteredActivity;
    public String getEnteredActivity() {return m_strEnteredActivity;}
    public VoiceFormResultBundle setEnteredActivity(String strEnteredActivity) {m_strEnteredActivity = strEnteredActivity; return this;}
    
    private Integer m_iRequestedNumber;
    public Integer getRequestedNumber() {return m_iRequestedNumber;}
    public VoiceFormResultBundle setRequestedNumber(Integer iRequestedNumber) {m_iRequestedNumber = iRequestedNumber; return this;}
    
    private String m_strRequestedUnit;
    public String getRequestedUnit() {return m_strRequestedUnit;}
    public VoiceFormResultBundle setRequestedUnit(String strRequestedUnit) {m_strRequestedUnit = strRequestedUnit; return this;}
    
    /** string representation of the requested attribute */
    private String m_strRequestedAttribute;
    public String getRequestedAttribute() {return m_strRequestedAttribute;}
    public VoiceFormResultBundle setRequestedAttribute(String strRequestedAttribute) {m_strRequestedAttribute = strRequestedAttribute; return this;}
	
    /** string representations of the attribute results */
    private List<String> m_listAttributeResults;
    public List<String> getAttributeResults() {return m_listAttributeResults;}
    public VoiceFormResultBundle setAttributeResults(List<String> listAttributeResults) {m_listAttributeResults = listAttributeResults; return this;}
    
	public static VoiceFormResultBundle fromBundle(Bundle result)
	{ 
		return new VoiceFormResultBundle()
			.setResultType(result.getInt(KEY_RESULTTYPE))
			.setEnteredActivity(result.getString(KEY_ENTEREDACTIVITY))
			.setRequestedNumber(result.getInt(KEY_REQUESTEDNUMBER))
			.setRequestedUnit(result.getString(KEY_REQUESTEDUNIT))
			.setAttributeResults(result.getStringArrayList(KEY_ATTRIBUTERESULTS));
	}
	
	
	public static Bundle createBundleFromVoiceFormResultBean(VoiceFormResultBean resultBean)
	{
		Bundle bundle = new Bundle();

        if (resultBean != null)
        {
        	if (resultBean.getResultType() != null)
        		bundle.putInt(KEY_RESULTTYPE, resultBean.getResultType());
        	
        	if (resultBean.getEnteredActivity() != null)
        		bundle.putString(KEY_ENTEREDACTIVITY, resultBean.getEnteredActivity());
        	
        	if (resultBean.getRequestedNumber() != null)
        		bundle.putInt(KEY_REQUESTEDNUMBER, resultBean.getRequestedNumber());
        	
        	if (resultBean.getRequestedUnit() != null)
        		bundle.putString(KEY_REQUESTEDUNIT, resultBean.getRequestedUnit());
        	
        	if (resultBean.getAttributeResults() != null)
        		bundle.putStringArrayList(KEY_ATTRIBUTERESULTS, new ArrayList<String>(resultBean.getAttributeResults()));
        }

		return bundle;
	}
	
	
	
	
	/*
	
	
	
    /** a string representation of the entered activity
    
    
    
    /** creates a VoiceFormResultBean from a VoiceFormResult
    public static VoiceFormResultBean createFromResult(VoiceFormResult result) 
    {
		return new VoiceFormResultBean()
			.setResultType(result.getResultType())
			.setEnteredActivity(result.getEnteredActivityAsString())
			.setRequestedNumber(result.getRequestedNumberOrNull())
			.setRequestedUnit(result.getRequestedUnitOrNull())
			.setRequestedAttribute(result.getRequestedAttributeAsString())
			.setAttributeResults(result.getAttributeResultsAsString());
	}
    
	
	
	
	try
	{
		
		voiceFormResult ;
		Log.d(TAG, "result: "+voiceFormResult.getResultType());
		
		com.cluedup.commons.data.Activity activity = voiceFormResult.getEnteredActivityOrNull();
		
		if (activity != null)
		{
			if (activity.getActionOrNull() != null)
				Log.d(TAG, "Action: "
					+activity.getActionOrNull().getTokenAsJava(null)
					+" | "+activity.getActionOrNull().getLemmaAsJava(null)
				);
			
			if (activity.getActiveSubjectAsJava() != null)
				Log.d(TAG, "Active Subject: "
					+activity.getActiveSubjectAsJava().getTokenAsJava(null)
					+" | "+activity.getActiveSubjectAsJava().getLemmaAsJava(null)
				);
			
			if (activity.getDirectObjectAsJava() != null)
				Log.d(TAG, "Direct Object: "
					+activity.getDirectObjectAsJava().getTokenAsJava(null)
					+" | "+activity.getDirectObjectAsJava().getLemmaAsJava(null)
				);
			
			if (voiceFormResult.getAttributeResults() != null)
			{
				Log.d(TAG, "Attribute results: "+voiceFormResult.getAttributeResults().size());
				
				for (VoiceAttributeResult<Object> attrResult: voiceFormResult.getAttributeResults())
				{
					Log.d(TAG, "  Attribute: "+attrResult.getNameOrNull()+" | "+attrResult.getResultAsJava().size());
					
					for (Object resultObject: attrResult.getResultAsJava())
					{
						if (resultObject instanceof String)
							Log.d(TAG, "    Result(String): "+((String)resultObject));
						
						if (resultObject instanceof Integer)
							Log.d(TAG, "    Result(Integer): "+((Integer)resultObject));
					}
				}
			}
		}
		
		
	}
	catch (VoiceFormException e)
	{
		e.printStackTrace();
	}
	
	
	
    
	//pack the attributes
	m_VoiceFormBundle.putStringArrayList(VoiceForm$.MODULE$.KEY_LISTATTRIBUTES(), m_listAttributes);
	*/
	    	    
}
