package de.clued_up.voicecontrols.data;

import java.util.ArrayList;

import android.os.Bundle;

import de.clued_up.voicecontrols.backend.apiVoiceForm.model.VoiceFormBean;


public class VoiceFormConfiguration
{
	private static final String KEY_LISTCOMMANDACTION = "com.cluedup.voicecontrols.data.VoiceFormConfiguration.KEY_LISTCOMMANDACTION";
	private static final String KEY_LISTCOMMANDOBJECT = "com.cluedup.voicecontrols.data.VoiceFormConfiguration.KEY_LISTCOMMANDOBJECT";
	private static final String KEY_ACTION = "com.cluedup.voicecontrols.data.VoiceFormConfiguration.KEY_ACTION";
	private static final String KEY_ENQUIRY = "com.cluedup.voicecontrols.data.VoiceFormConfiguration.KEY_ENQUIRY";
    private static final String KEY_REPEATEDENQUIRY = "com.cluedup.voicecontrols.data.VoiceFormConfiguration.KEY_REPEATEDENQUIRY";
    private static final String KEY_UNIT = "com.cluedup.voicecontrols.data.VoiceFormConfiguration.KEY_UNIT";
	private static final String KEY_ATTRIBUTES = "com.cluedup.voicecontrols.data.VoiceFormConfiguration.KEY_ATTRIBUTES";
	private static final String KEY_CONTEXTATTRIBUTE = "com.cluedup.voicecontrols.data.VoiceFormConfiguration.KEY_CONTEXTATTRIBUTE";
	private static final String KEY_LABEL = "com.cluedup.voicecontrols.data.VoiceFormConfiguration.KEY_LABEL";
	private static final String KEY_ICONRESOURCE = "com.cluedup.voicecontrols.data.VoiceFormConfiguration.KEY_ICONRESOURCE";
    private static final String KEY_BACKGROUNDIMAGE = "com.cluedup.voicecontrols.data.VoiceFormConfiguration.KEY_BACKGROUNDIMAGE";
	private static final String KEY_ENQUIRYACTION = "com.cluedup.voicecontrols.data.VoiceFormConfiguration.KEY_ENQUIRYACTION";
	private static final String KEY_ENQUIRYACTIONICON = "com.cluedup.voicecontrols.data.VoiceFormConfiguration.KEY_ENQUIRYACTIONICON";
	
	private final Bundle m_VoiceFormBundle;
	
	public VoiceFormConfiguration()
	{
		m_VoiceFormBundle = new Bundle();
	}
	
	public VoiceFormConfiguration setLabel(String strLabel)
	{
		m_VoiceFormBundle.putString(KEY_LABEL, strLabel);
		return this;
	}
	
	public VoiceFormConfiguration setIconResource(int iIconRes)
	{
		m_VoiceFormBundle.putInt(KEY_ICONRESOURCE, iIconRes);
		return this;
	}
	
	public VoiceFormConfiguration setEnquiryAction(String strEnquiryAction)
	{
		m_VoiceFormBundle.putString(KEY_ENQUIRYACTION, strEnquiryAction);
		return this;
	}
	
	public VoiceFormConfiguration setEnquiryActionIcon(int iIconRes)
	{
		m_VoiceFormBundle.putInt(KEY_ENQUIRYACTIONICON, iIconRes);
		return this;
	}

    public VoiceFormConfiguration setBackgroundImageResource(int iBackgroundRes)
    {
        m_VoiceFormBundle.putInt(KEY_BACKGROUNDIMAGE, iBackgroundRes);
        return this;
    }

	public VoiceFormConfiguration setListCommandAction(ArrayList<String> listCommandAction)
	{
		m_VoiceFormBundle.putStringArrayList(KEY_LISTCOMMANDACTION, listCommandAction);
		return this;
	}
	
	public VoiceFormConfiguration setListCommandObject(ArrayList<String> listCommandObject)
	{
		m_VoiceFormBundle.putStringArrayList(KEY_LISTCOMMANDOBJECT, listCommandObject);
		return this;
	}

	public VoiceFormConfiguration setAction(String strAction)
	{
		m_VoiceFormBundle.putString(KEY_ACTION, strAction);
		return this;
	}
	
	private ArrayList<String> m_listAttributes = new ArrayList<String>();
	public VoiceFormConfiguration addAttribute(VoiceAttributeConfiguration attribute)
	{
		m_listAttributes.add(attribute.parseToString());
		return this;
	}
	
	public VoiceFormConfiguration setEnquiry(String strEnquiry)
	{
		m_VoiceFormBundle.putString(KEY_ENQUIRY, strEnquiry);
		return this;
	}

    public VoiceFormConfiguration setRepeatedEnquiry(String strEnquiry)
    {
        m_VoiceFormBundle.putString(KEY_REPEATEDENQUIRY, strEnquiry);
        return this;
    }
	
	public VoiceFormConfiguration setUnit(String strUnit)
	{
		m_VoiceFormBundle.putString(KEY_UNIT, strUnit);
		return this;
	}
	
	public Bundle toBundle()
	{
		m_VoiceFormBundle.putStringArrayList(KEY_ATTRIBUTES, m_listAttributes);
		return m_VoiceFormBundle;
	}
	
	public static VoiceFormBean createVoiceFormBeanFromBundle(Bundle bundle)
	{
		ArrayList<String> listUnits = new ArrayList<String>();
		listUnits.add(bundle.getString(KEY_UNIT));
		
		return new VoiceFormBean()
			.setIconResource(bundle.getInt(KEY_ICONRESOURCE))
			.setLabel(bundle.getString(KEY_LABEL))
			.setAction(bundle.getString(KEY_ACTION))
			.setCommandActions(bundle.getStringArrayList(KEY_LISTCOMMANDACTION))
			.setCommandObjects(bundle.getStringArrayList(KEY_LISTCOMMANDOBJECT))
			.setEnquiry(bundle.getString(KEY_ENQUIRY))
            .setRepeatedEnquiry(bundle.getString(KEY_REPEATEDENQUIRY))
			.setEnquiryAction(bundle.getString(KEY_ENQUIRYACTION))
			.setEnquiryActionIconResource(bundle.getInt(KEY_ENQUIRYACTIONICON))
            .setBackgroundImageResource(bundle.getInt(KEY_BACKGROUNDIMAGE))
			.setUnits(listUnits)
			.setAttributes(bundle.getStringArrayList(KEY_ATTRIBUTES))
			.setContextAttribute(bundle.getString(KEY_CONTEXTATTRIBUTE));
	}

	
	
	/*public static ArrayList<VoiceAttributeBean> createAttributeBeansListFromBundle(Bundle bundle)
	{
		ArrayList<VoiceAttributeBean> listAttributes = new ArrayList<VoiceAttributeBean>();
		final ArrayList<String> listStrings = bundle.getStringArrayList(KEY_ATTRIBUTES);
		
		if (listStrings != null)
		for (String strAttribute: listStrings)
			listAttributes.add(VoiceAttributeConfiguration.parseFromString(strAttribute));
		
		return listAttributes;
	}*/

	
}
