package de.clued_up.voicecontrols.data;

import java.util.ArrayList;

public class VoiceAttributeResultBundle<AttributeType>
{
	private static VoiceAttributeResultBundle createNewVoiceAttributeResult(int attributeType)
	{
		switch (attributeType)
		{
			case VoiceAttributeConfiguration.VALUETYPE_FREETEXT:
			case VoiceAttributeConfiguration.VALUETYPE_LIST:
				return new VoiceAttributeResultBundle<String>().setType(attributeType);
				
		/*TODO	case VoiceAttributeConfiguration.VALUETYPE_TIME:
				return new VoiceAttributeResultBundle<Timestamp>();
			*/
				
			default:
				return null;
		}
		
	}
	
	public static VoiceAttributeResultBundle parseFromString(String strAttributeResult)
	{
		Tuple tupleName = Tuple.getField(strAttributeResult);
		Tuple tupleType = Tuple.getField(tupleName.str2);
		
		try
		{
			VoiceAttributeResultBundle result = createNewVoiceAttributeResult(Integer.parseInt(tupleType.str1));
			result.setName(tupleName.str1);
			
			//TODO: when we have other types than Strings!!
			ArrayList<String> listResults = new ArrayList<String>();
			
			String strRest = tupleType.str2;
			while (strRest != null && strRest != "")
			{
				Tuple tupleValue = Tuple.getField(strRest);
				
				if (tupleValue.str1 != null)
					listResults.add(tupleValue.str1);
				
				strRest = tupleValue.str2;
			}
			result.setResults(listResults);
			
			return result;
		}
		catch (NumberFormatException e) {e.printStackTrace();}
		return null;
	}
	
	
	/** the name of the attribute  */
	private String m_strName;
	public String getName(){return m_strName;}
	public VoiceAttributeResultBundle<AttributeType> setName(String strName)
	{
		m_strName = strName;
		return this;
	}

	/** the type of the attribute  */
	private int m_iType;
	public int getType(){return m_iType;}
	public VoiceAttributeResultBundle<AttributeType> setType(int iType)
	{
		m_iType = iType;
		return this;
	}
	
	private ArrayList<AttributeType> m_listResults;
	public ArrayList<AttributeType> getResults(){return m_listResults;}
	public VoiceAttributeResultBundle<AttributeType> setResults(ArrayList<AttributeType> listResults)
	{
		m_listResults = listResults;
		return this;
	}
	
}
