package de.clued_up.voicecontrols.data;

import java.util.ArrayList;
import java.util.List;



public class VoiceAttributeConfiguration
{
	/** must match the values of VoiceAttribute.scala */
	public static final int VALUETYPE_FREETEXT = 0;
	public static final int VALUETYPE_LIST = 1;
	public static final int VALUETYPE_TIME = 2;
	
	private static final String TAG = "com.cluedup.voicecontrols.data.VoiceAttributeConfiguration";
	
	
	
	
	public String parseToString()
	{
		StringBuilder sb = new StringBuilder()
	      .append(m_iValueType != null ? m_iValueType.toString() : "").append("#")
	      .append(m_strName != null ? m_strName : "").append("#")
	      .append(m_strPreposition != null ? m_strPreposition : "").append("#")
	      .append(m_bMandatory ? "0" : "1").append("#")
	      .append(m_strEnquiry != null ? m_strEnquiry : "").append("#")
	      .append(m_strEnquiryAction != null ? m_strEnquiryAction : "").append("#")
	      .append(m_iEnquiryActionIconResource != null ? m_iEnquiryActionIconResource.toString() : "").append("#")
	      .append(m_iNoOfValues.toString()).append("#");
	   
		for (String strValue: m_listValues)
			sb.append(strValue).append("|");
        sb.append("#");

        if (m_listApplicableCommandObjects != null)
            for (String strValue: m_listApplicableCommandObjects)
                sb.append(strValue).append("|");

	    return sb.toString();
	}

	public static VoiceAttributeConfiguration parseFromString(String strAttribute)
	{
		VoiceAttributeConfiguration result = new VoiceAttributeConfiguration();
		
		Tuple tupleValueType = Tuple.getBundle(strAttribute);
		try {result.setValueType(Integer.parseInt(tupleValueType.str1));}
		catch (NumberFormatException e) {e.printStackTrace();}
		
		Tuple tupleName = Tuple.getBundle(tupleValueType.str2);
		result.setName(tupleName.str1);
		
		Tuple tuplePreposition = Tuple.getBundle(tupleName.str2);
		result.setPreposition(tuplePreposition.str1);
		
		Tuple tupleIsMandatory = Tuple.getBundle(tuplePreposition.str2);
		result.setIsMandatory(tupleIsMandatory.str1.compareToIgnoreCase("0") == 0);
		
		Tuple tupleEnquiry = Tuple.getBundle(tupleIsMandatory.str2);
		result.setEnquiry(tupleEnquiry.str1);
		
		Tuple tupleEnquiryAction = Tuple.getBundle(tupleEnquiry.str2);
		result.setEnquiryAction(tupleEnquiryAction.str1);
		
		Tuple tupleEnquiryActionIconResource = Tuple.getBundle(tupleEnquiryAction.str2);
		try {result.setEnquiryActionIconResource(Integer.parseInt(tupleEnquiryActionIconResource.str1));}
		catch (NumberFormatException e) {e.printStackTrace();}
		
		Tuple tupleNoOfValues = Tuple.getBundle(tupleEnquiryActionIconResource.str2);
		try {result.setNoOfValues(Integer.parseInt(tupleNoOfValues.str1));}
		catch (NumberFormatException e) {e.printStackTrace();}
		
		ArrayList<String> listValues = new ArrayList<String>();
        Tuple tupleValues = Tuple.getBundle(tupleNoOfValues.str2);
		while (tupleValues.str1 != null && tupleValues.str1 != "")
		{
			Tuple tupleValue = Tuple.getField(tupleValues.str1);
			
			if (tupleValue.str1 != null)
				listValues.add(tupleValue.str1);

            tupleValues.str1 = tupleValue.str2;
		}
		result.setValueList(listValues);

        ArrayList<String> listApplicableCommandObjects = new ArrayList<String>();
        Tuple tupleCommandObjects = Tuple.getBundle(tupleValues.str2);
        while (tupleCommandObjects.str1 != null && tupleCommandObjects.str1 != "")
        {
            Tuple tupleObject = Tuple.getField(tupleCommandObjects.str1);

            if (tupleObject.str1 != null)
                listValues.add(tupleObject.str1);

            tupleCommandObjects.str1 = tupleObject.str2;
        }
        result.setApplicableCommandObjectList(listApplicableCommandObjects);

		return result;
	}

	private Integer m_iValueType;
    public Integer getValueType() {return m_iValueType;}
    public VoiceAttributeConfiguration setValueType(int valueType) {m_iValueType = valueType; return this;}
	
    private List<String> m_listValues;
    public List<String> getValueList() {return m_listValues;}
    public VoiceAttributeConfiguration setValueList(List<String> listValues) {m_listValues = listValues; return this;}

    private List<String> m_listApplicableCommandObjects;
    public List<String> getApplicableCommandObjectList() {return m_listApplicableCommandObjects;}
    public VoiceAttributeConfiguration setApplicableCommandObjectList(List<String> listCommandObjects) {
        m_listApplicableCommandObjects = listCommandObjects; return this;}

    private String m_strName;
    public String getName() {return m_strName;}
    public VoiceAttributeConfiguration setName(String strName) {m_strName = strName; return this;}
    
    private String m_strPreposition;
    public String getPreposition() {return m_strPreposition;}
    public VoiceAttributeConfiguration setPreposition(String strPreposition) {m_strPreposition = strPreposition; return this;}
    
    private Boolean m_bMandatory;
    public Boolean getIsMandatory() {return m_bMandatory;}
    public VoiceAttributeConfiguration setIsMandatory(boolean bMandatory) {m_bMandatory = bMandatory; return this;}
   
    private Integer m_iNoOfValues;
    public Integer getNoOfValues() {return m_iNoOfValues;}
    public VoiceAttributeConfiguration setNoOfValues(int iNoOfValues) {m_iNoOfValues = iNoOfValues; return this;}
    
    private String m_strEnquiry;
    public String getEnquiry() {return m_strEnquiry;}
    public VoiceAttributeConfiguration setEnquiry(String strEnquiry) {m_strEnquiry = strEnquiry; return this;}
    
    private String m_strEnquiryAction;
    public String getEnquiryAction() {return m_strEnquiryAction;}
    public VoiceAttributeConfiguration setEnquiryAction(String strEnquiryAction) {m_strEnquiryAction = strEnquiryAction; return this;}
    
    private Integer m_iEnquiryActionIconResource;
    public Integer getEnquiryActionIconResource() {return m_iEnquiryActionIconResource;}
    public VoiceAttributeConfiguration setEnquiryActionIconResource(int iEnquiryActionIconResource) {m_iEnquiryActionIconResource = iEnquiryActionIconResource; return this;}
    
  
}
