package de.clued_up.voicecontrols.async;

import java.util.ArrayList;

import android.os.Bundle;

/** remembers all the async tasks that run and keeps track of them */
public class AsyncTaskTracker
{
	
	
	private static final String TAG = "AsyncTaskTracker";

	/** the Supporter bears the */
	private final de.clued_up.voicecontrols.async.AsyncTaskSupporter m_AsyncTaskSupporter;
	
	ArrayList<TrackedAsyncTask> m_listAsyncTasks;
	
	/** contains the current message */
	String m_strAsyncMessage = null;
	public String getAsyncMessage(){return m_strAsyncMessage;}
	
	public AsyncTaskTracker(de.clued_up.voicecontrols.async.AsyncTaskSupporter supporter)
	{
		m_AsyncTaskSupporter = supporter;
		m_listAsyncTasks = new ArrayList<TrackedAsyncTask>();
	}
	
	/** how many async tasks are running currently? */
	public int getAsyncCount()
	{
		if (m_listAsyncTasks == null)
			return 0;
		
		return m_listAsyncTasks.size();
	}
	
	/** an async task has started */
	void onAsyncTaskStarted(TrackedAsyncTask task)
	{
		if (m_listAsyncTasks == null)
			m_listAsyncTasks = new ArrayList<TrackedAsyncTask>();
		
		m_listAsyncTasks.add(task);
		
		m_AsyncTaskSupporter.onAsyncTaskStarted(getAsyncCount());
		
		//Log.d(TAG, "start task, async tasks running: "+getAsyncCount());
		
	}
	
	/** an async task has stopped */
	void onAsyncTaskStopped(TrackedAsyncTask task)
	{
		if (m_listAsyncTasks != null)
			m_listAsyncTasks.remove(task);
		
		m_AsyncTaskSupporter.onAsyncTaskStopped(getAsyncCount());
		
		//Log.d(TAG, "stop task, async tasks running: "+getAsyncCount());
	}
	
	/** an async task has sent an update, e.g. a new message */
	void onAsyncTaskUpdated(TrackedAsyncTask task, Bundle args)
	{
		m_strAsyncMessage = args.getString(TrackedAsyncTask.KEY_UPDATEMESSAGE);		
		m_AsyncTaskSupporter.onAsyncTaskUpdated(m_strAsyncMessage);
		
	}

	/** checks whether an async task with the specified key is running already*/
	public boolean isRunning(String key)
	{
		if (m_listAsyncTasks == null || key == null)
			return false;
		
		for (int i=0; i<m_listAsyncTasks.size();i++)
		{
			try
			{
				final String taskkey = m_listAsyncTasks.get(i).getKey();
				if (taskkey != null && taskkey.compareTo(key) == 0)
					return true;
			}
			catch (IndexOutOfBoundsException e)
			{
				//when we are out of the index, some task seems to have ended in the meanwhile
				//since we're counting up, we have reached the end and can stop 
				return false;
			}
		}
		
		return false;
	}
	
	/** aborts the task specified by the key*/
	public boolean abortTask(String key)
	{
		if (m_listAsyncTasks == null || key == null)
			return false;
		
		for (int i=0; i<m_listAsyncTasks.size();i++)
		{
			try
			{
				final String taskkey = m_listAsyncTasks.get(i).getKey();
				if (taskkey != null && taskkey.compareTo(key) == 0)
				{
					m_listAsyncTasks.get(i).abortTask();
					return true;
				}
			}
			catch (IndexOutOfBoundsException e)
			{
				//when we are out of the index, some task seems to have ended in the meanwhile
				//since we're counting up, we have reached the end and can stop 
				return false;
			}
		}
		
		return false;
	}
	
}
