package de.clued_up.voicecontrols.async;

/** holds an accesses an asyncTaskTracker. should be the application since that always
 * runs, even if no activity is active,
 * connects the async tasks with the progressAnimator and makes sure that the current
 * message is shown in the correct ProgressAnimator*/
public interface AsyncTaskSupporter
{
	/** provide access to the task tracker */
	AsyncTaskTracker getAsyncTaskTracker();
	
	/** sets a new progress animator that should show any progress messages to the user
	 * from now on, can be null if there is no animator*/
	void setCurrentProgressAnimator(ProgressAnimator animator);
	
	/** notifies the Supporter that a new AsyncTask was started, passes the number of tasks that
	 * are running now */
	void onAsyncTaskStarted(int newcount);
	
	/** notifies the Supporter that a AsyncTask was stopped, passes the number of tasks that
	 * are running now */
	void onAsyncTaskStopped(int newcount);

	/** notifies the Supporter that an async task has provided a message, can be null */
	void onAsyncTaskUpdated(String strMessage);
	
}
