package de.clued_up.voicecontrols;

import java.util.ArrayList;
import java.util.Arrays;

import de.clued_up.voicecontrols.data.VoiceAttributeConfiguration;
import de.clued_up.voicecontrols.data.VoiceFormConfiguration;
import de.clued_up.voicecontrols.services.VoiceControlService;
import de.clued_up.voicecontrols.voiceform.VoiceFormBuilder;
import de.clued_up.voicecontrols.voiceform.VoiceFormListener;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.widget.Toast;

public class TestActivity extends Activity
{
	protected static final String TAG = TestActivity.class.toString();
	
	protected static final String KEY_FORMSERVICE = "de.clued_up.voicecontrols.TestApplication.KEY_FORMSERVICE";


    @Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);

		//create a new Voice Form
		new VoiceFormBuilder(getApplicationContext(), KEY_FORMSERVICE,
				new VoiceFormConfiguration()
					.setIconResource(R.drawable.ic_launcher)
					.setLabel("Delivery Service")
					.setEnquiry("What do you want to order?")
					.setEnquiryAction("Order now")
					.setEnquiryActionIcon(R.drawable.ic_launcher)
                    .setBackgroundImageResource(R.drawable.ic_launcher)
					.setAction("have")
					.setListCommandAction(new ArrayList<String>(Arrays.asList("give", "deliver", "get", "order")))
					.setListCommandObject(new ArrayList<String>(Arrays.asList("pizza", "spaghetti", "pasta")))
                    .addAttribute(new VoiceAttributeConfiguration()
                            .setName("Sauce")
                            .setPreposition("with")
                            .setNoOfValues(2)
                            .setEnquiry("What sauce do you want your spaghetti with?")
                            .setEnquiryAction("Specify sauce")
                            .setEnquiryActionIconResource(R.drawable.ic_launcher)
                            .setValueType(VoiceFormBuilder.VALUETYPE_LIST)
                            .setValueList(Arrays.asList("arrabiata", "bolognese", "napoli"))
                            .setIsMandatory(true))
                    .addAttribute(new VoiceAttributeConfiguration()
						.setName("Topping")
			    	    .setPreposition("with")
			    	    .setNoOfValues(2)
			    	    .setEnquiry("What do you want to have on your pizza?")
			    	    .setEnquiryAction("Add toppings")
			    	    .setEnquiryActionIconResource(R.drawable.ic_launcher)
			    	    .setValueType(VoiceFormBuilder.VALUETYPE_LIST)
			    	    .setValueList(Arrays.asList("salami", "cheese", "pepperoni", "anchovi", "mushroom"))
			    	    .setIsMandatory(true)),
				new VoiceFormListener()
				{

					@Override
					public void onVoiceFormCanceled(int iErrorCode)
					{
						Log.d(TAG, "onVoiceFormCanceled: "+iErrorCode);
						
						if (iErrorCode == VoiceControlService.VFE_LIMITEXCEEDED)
							Log.d(TAG, "unfortunately, you exceeded your limit of requests!");


                        Toast.makeText(TestActivity.this,
                                "onVoiceFormCanceled: "+iErrorCode,
                                Toast.LENGTH_LONG).show();
					}

					@Override
					public void onVoiceFormCompleted(Bundle result)
					{
						Log.d(TAG, "onVoiceFormCompleted");

                        Toast.makeText(TestActivity.this,
                                "onVoiceFormCompleted",
                                Toast.LENGTH_LONG).show();

						/*VoiceFormResultBundle voiceFormResult = VoiceFormResultBundle.fromBundle(result);
						
						VoiceAttributeResultBundle resultTopping = voiceFormResult.getAttributeResultByName("Topping");
						List<String> listOfToppings = resultTopping.getResults();

						
						Log.d(TAG, "result: "+voiceFormResult.getResultType());
						Log.d(TAG, "enteredActivity: "+voiceFormResult.getEnteredActivity());
						*/
						
					}
			
				}
		)
		.start();
	
		finish();
	}

}
