/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.configured.format;

import de.clickism.configured.format.BaseFormat;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.snakeyaml.engine.v2.api.Dump;
import org.snakeyaml.engine.v2.api.DumpSettings;
import org.snakeyaml.engine.v2.api.Load;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.common.FlowStyle;

public class YamlFormat
extends BaseFormat {
    private final Load load = new Load(LoadSettings.builder().build());
    private final Dump dump = new Dump(DumpSettings.builder().setMultiLineFlow(true).setDefaultFlowStyle(FlowStyle.BLOCK).build());

    protected YamlFormat() {
    }

    public static YamlFormat yaml() {
        return new YamlFormat();
    }

    @NotNull
    public Map<String, Object> read(File file) throws Exception {
        try {
            Map map = (Map)this.load.loadFromString(Files.readString(file.toPath()));
            return map != null ? map : new HashMap();
        }
        catch (Exception e) {
            throw new IOException("Failed to read config file: " + file.getPath(), e);
        }
    }

    public String formatComment(String comment) {
        return "# " + comment.replaceAll("\n", "\n# ");
    }

    protected void writeKeyValue(StringBuilder sb, String key, Object value, boolean hasNext) {
        Object string = this.dumpToString(value);
        sb.append(key).append(":");
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (collection.isEmpty()) {
                sb.append(" []\n");
                return;
            }
            sb.append("\n");
        } else {
            if (value instanceof Map) {
                Map map = (Map)value;
                if (map.isEmpty()) {
                    sb.append(" {}\n");
                    return;
                }
                sb.append("\n");
                string = "  " + ((String)string).replaceAll("\n", "\n  ").stripTrailing();
                sb.append((String)string);
                sb.append("\n");
                return;
            }
            sb.append(" ");
        }
        sb.append((String)string);
    }

    private String dumpToString(Object value) {
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return this.dump.dumpToString(new ArrayList(collection));
        }
        return this.dump.dumpToString(value);
    }

    protected void writeFormatHeader(StringBuilder sb) {
    }

    protected void writeFormatFooter(StringBuilder sb) {
    }
}

