/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.configured.format;

import de.clickism.configured.format.BaseFormat;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class YamlFormat
extends BaseFormat {
    private final Yaml yaml;

    protected YamlFormat() {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setPrettyFlow(true);
        this.yaml = new Yaml(options);
    }

    public static YamlFormat yaml() {
        return new YamlFormat();
    }

    @NotNull
    public Map<String, Object> read(File file) throws Exception {
        try {
            Map map = (Map)this.yaml.load(Files.readString(file.toPath()));
            return map != null ? map : new HashMap();
        }
        catch (Exception e) {
            throw new IOException("Failed to read config file: " + file.getPath(), e);
        }
    }

    public String formatComment(String comment) {
        return "# " + comment.replaceAll("\n", "\n# ");
    }

    protected void writeKeyValue(StringBuilder sb, String key, Object value, boolean hasNext) {
        Object string = this.dumpToString(value);
        sb.append(key).append(":");
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (collection.isEmpty()) {
                sb.append(" []\n");
                return;
            }
            sb.append("\n");
        } else {
            if (value instanceof Map) {
                Map map = (Map)value;
                if (map.isEmpty()) {
                    sb.append(" {}\n");
                    return;
                }
                sb.append("\n");
                string = "  " + ((String)string).replaceAll("\n", "\n  ").stripTrailing();
                sb.append((String)string);
                sb.append("\n");
                return;
            }
            sb.append(" ");
        }
        sb.append((String)string);
    }

    private String dumpToString(Object value) {
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return this.yaml.dump(new ArrayList(collection));
        }
        return this.yaml.dump(value);
    }

    protected void writeFormatHeader(StringBuilder sb) {
    }

    protected void writeFormatFooter(StringBuilder sb) {
    }
}

