/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.configured.format;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import de.clickism.configured.format.BaseFormat;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JsonFormat
extends BaseFormat {
    private final JsonType type;
    private final Gson gson;

    public JsonFormat(JsonType type) {
        this.type = type;
        GsonBuilder builder = new GsonBuilder();
        this.setupForType(builder);
        this.gson = builder.setPrettyPrinting().setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LAZILY_PARSED_NUMBER).create();
    }

    public static JsonFormat json() {
        return new JsonFormat(JsonType.JSON);
    }

    public static JsonFormat jsonc() {
        return new JsonFormat(JsonType.JSONC);
    }

    @NotNull
    public Map<String, Object> read(File file) throws IOException {
        try {
            Map map = (Map)this.gson.fromJson((Reader)new FileReader(file), Map.class);
            if (map == null) {
                throw new IOException("GSON returned null!");
            }
            return map;
        }
        catch (Exception e) {
            throw new IOException("Failed to read config file: " + file.getPath() + ". Expected type: " + this.type.name() + ". Please verify the JSON format (.json, .jsonc, .json5).", e);
        }
    }

    public String formatComment(String comment) {
        return "  // " + comment.replaceAll("\n", "\n  // ");
    }

    protected void writeKeyValue(StringBuilder sb, String key, Object value, boolean hasNext) {
        String string = this.gson.toJson(value).replaceAll("\n", "\n  ");
        sb.append("  \"").append(key).append("\": ").append(string);
        if (hasNext) {
            sb.append(',');
        }
        sb.append('\n');
    }

    protected void writeFormatHeader(StringBuilder sb) {
        sb.append("{\n");
    }

    protected void writeFormatFooter(StringBuilder sb) {
        sb.append('}');
    }

    public void writeComments(boolean writeComments) {
        super.writeComments(writeComments && this.type.allowsComments());
    }

    private void setupForType(GsonBuilder builder) {
        if (this.type == JsonType.JSON) {
            this.writeComments(false);
            this.separateConfigOptions(false);
            builder.setLenient();
        }
    }

    public static enum JsonType {
        JSON,
        JSONC;


        private boolean allowsComments() {
            return this == JSONC;
        }
    }
}

