/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickgui.menu.handler;

import de.clickism.clickgui.menu.handler.ClickHandler;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class StaticClickHandler
implements ClickHandler {
    @Override
    public boolean handleClick(InventoryClickEvent event) {
        return false;
    }

    @Override
    public void handleDrag(InventoryDragEvent event) {
        int size = event.getView().getTopInventory().getSize();
        for (Integer slot : event.getRawSlots()) {
            if (slot >= size) continue;
            event.setCancelled(true);
            return;
        }
    }

    @Override
    public boolean isValidClick(InventoryClickEvent event) {
        if (this.isIllegalShiftClick(event)) {
            return false;
        }
        if (this.isIllegalDoubleClick(event)) {
            return false;
        }
        Inventory clickedInventory = event.getClickedInventory();
        Inventory topInventory = event.getView().getTopInventory();
        if (clickedInventory != null && !clickedInventory.equals((Object)topInventory)) {
            return true;
        }
        return event.getCurrentItem() != null;
    }

    protected boolean isIllegalShiftClick(InventoryClickEvent event) {
        if (!event.getClick().isShiftClick()) {
            return false;
        }
        return event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY;
    }

    protected boolean isIllegalDoubleClick(InventoryClickEvent event) {
        if (event.getClick() != ClickType.DOUBLE_CLICK) {
            return false;
        }
        if (event.getAction() != InventoryAction.COLLECT_TO_CURSOR) {
            return false;
        }
        ItemStack cursor = event.getCursor();
        if (cursor == null) {
            return false;
        }
        for (ItemStack item : event.getView().getTopInventory()) {
            if (item == null || !item.isSimilar(cursor)) continue;
            return true;
        }
        return false;
    }
}

