/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickgui.menu;

import de.clickism.clickgui.menu.Button;
import de.clickism.clickgui.menu.Menu;
import de.clickism.clickgui.menu.MenuManager;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;

public class MenuView {
    private final Menu menu;
    private final Inventory inventory;
    private final MenuManager menuManager;

    public MenuView(Menu menu, Inventory inventory, MenuManager menuManager) {
        this.menu = menu;
        this.inventory = inventory;
        this.menuManager = menuManager;
    }

    public void close() {
        this.menu.getPlayer().closeInventory();
    }

    public void open(Menu menu) {
        menu.open(this.menuManager);
    }

    public void reopen() {
        this.menu.open(this.menuManager);
    }

    public void refresh(int slot) {
        Button button = this.menu.getButton(slot);
        if (button == null) {
            this.inventory.setItem(slot, null);
            return;
        }
        this.inventory.setItem(slot, button.icon.get());
    }

    public void refresh() {
        for (int i = 0; i < this.menu.buttons.length; ++i) {
            this.refresh(i);
        }
    }

    protected void onClick(InventoryClickEvent event) {
        if (!this.menu.clickHandler.isValidClick(event)) {
            event.setCancelled(true);
            return;
        }
        if (this.menu.clickHandler.handleClick(event)) {
            return;
        }
        Button button = this.menu.buttons[event.getRawSlot()];
        if (button != null) {
            button.handleClick(event, this);
        }
    }

    protected void onDrag(InventoryDragEvent event) {
        this.menu.clickHandler.handleDrag(event);
    }

    protected void onClose() {
        this.menu.onClose.accept(this);
    }

    public Player getPlayer() {
        return this.menu.getPlayer();
    }

    public Menu getMenu() {
        return this.menu;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public MenuManager getMenuManager() {
        return this.menuManager;
    }
}

