/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickgui.menu;

import de.clickism.clickgui.menu.Menu;
import de.clickism.clickgui.menu.MenuView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MenuManager
implements Listener {
    protected static MenuManager instance;
    private final JavaPlugin plugin;
    private final Map<Inventory, MenuView> activeMenus = new HashMap<Inventory, MenuView>();

    public MenuManager(JavaPlugin plugin) {
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public MenuView openMenu(Menu menu) {
        return menu.open(this);
    }

    public MenuView registerActiveView(MenuView view) {
        this.activeMenus.put(view.getInventory(), view);
        return view;
    }

    public void closeActiveMenus() {
        Iterator<Map.Entry<Inventory, MenuView>> iterator = this.activeMenus.entrySet().iterator();
        while (iterator.hasNext()) {
            List viewers = iterator.next().getKey().getViewers();
            iterator.remove();
            new ArrayList<HumanEntity>(viewers).forEach(HumanEntity::closeInventory);
        }
    }

    @EventHandler
    public void onDisable(PluginDisableEvent event) {
        if (!event.getPlugin().equals((Object)this.plugin)) {
            return;
        }
        this.closeActiveMenus();
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        this.runOnActiveView(event.getInventory(), view -> {
            int slot = event.getRawSlot();
            if (slot < 0 || slot >= view.getInventory().getSize()) {
                return;
            }
            view.onClick(event);
        });
    }

    @EventHandler
    public void onDrag(InventoryDragEvent event) {
        this.runOnActiveView(event.getInventory(), view -> view.onDrag(event));
    }

    @EventHandler
    public void onClose(InventoryCloseEvent event) {
        Inventory inventory = event.getInventory();
        this.runOnActiveView(inventory, view -> {
            this.activeMenus.remove(inventory);
            view.onClose();
        });
    }

    private void runOnActiveView(Inventory inventory, Consumer<MenuView> consumer) {
        MenuView view = this.activeMenus.get(inventory);
        if (view == null) {
            return;
        }
        consumer.accept(view);
    }

    @Nullable
    public static MenuManager getInstance() {
        return instance;
    }

    public static void setInstance(MenuManager instance) {
        if (MenuManager.instance != null) {
            throw new IllegalStateException("Instance already set");
        }
        MenuManager.instance = instance;
    }
}

