/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickgui.menu;

import de.clickism.clickgui.menu.Button;
import de.clickism.clickgui.menu.Colorized;
import de.clickism.clickgui.menu.InventorySupplier;
import de.clickism.clickgui.menu.MenuBackground;
import de.clickism.clickgui.menu.MenuManager;
import de.clickism.clickgui.menu.MenuType;
import de.clickism.clickgui.menu.MenuView;
import de.clickism.clickgui.menu.Utils;
import de.clickism.clickgui.menu.handler.ClickHandler;
import de.clickism.clickgui.menu.handler.StaticClickHandler;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.Nullable;

public class Menu {
    protected final Player player;
    protected final int size;
    protected final Button[] buttons;
    protected String title = "";
    protected MenuBackground background = slot -> null;
    protected final InventorySupplier inventorySupplier;
    protected ClickHandler clickHandler = new StaticClickHandler();
    protected Consumer<MenuView> onOpen = view -> {};
    protected Consumer<MenuView> onClose = view -> {};

    public Menu(Player player, MenuType type) {
        this(player, type.getSupplier(), type.getSize());
    }

    public Menu(Player player, InventoryType inventoryType) {
        this(player, title -> Bukkit.createInventory(null, (InventoryType)inventoryType, (String)title), inventoryType.getDefaultSize());
    }

    protected Menu(Player player, InventorySupplier inventorySupplier, int size) {
        this.player = player;
        this.inventorySupplier = inventorySupplier;
        this.size = size;
        this.buttons = new Button[size];
    }

    public Menu addButton(int slot, Button button) {
        if (slot >= this.size) {
            throw new IllegalArgumentException("Slot " + slot + " out of bounds for menu with size " + this.size);
        }
        this.buttons[slot] = button;
        return this;
    }

    public Menu setTitle(@Colorized String title) {
        this.title = Utils.colorize(title);
        return this;
    }

    public Menu setBackground(MenuBackground background) {
        this.background = background;
        return this;
    }

    public Menu setClickHandler(ClickHandler clickHandler) {
        this.clickHandler = clickHandler;
        return this;
    }

    public Menu setOnOpen(Consumer<MenuView> onOpen) {
        this.onOpen = onOpen;
        return this;
    }

    public Menu setOnClose(Consumer<MenuView> onClose) {
        this.onClose = onClose;
        return this;
    }

    private void placeButtons(Inventory inventory) {
        for (int i = 0; i < this.buttons.length; ++i) {
            Button button = this.getButton(i);
            if (button == null) continue;
            this.buttons[i] = button;
            inventory.setItem(i, button.icon.get());
        }
    }

    @Nullable
    public Button getButton(int slot) {
        Button button = this.buttons[slot];
        if (button != null) {
            return button;
        }
        return this.background.getButton(slot);
    }

    public MenuView open(MenuManager menuManager) {
        Inventory inventory = this.inventorySupplier.create(this.title);
        this.placeButtons(inventory);
        this.player.openInventory(inventory);
        MenuView view = new MenuView(this, inventory, menuManager);
        this.onOpen.accept(view);
        return menuManager.registerActiveView(view);
    }

    public MenuView open() {
        MenuManager menuManager = MenuManager.getInstance();
        if (menuManager == null) {
            throw new IllegalStateException("MenuManager instance not set");
        }
        return this.open(menuManager);
    }

    public Player getPlayer() {
        return this.player;
    }
}

