/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickgui.menu;

import de.clickism.clickgui.menu.Colorized;
import de.clickism.clickgui.menu.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@FunctionalInterface
public interface Icon {
    public ItemStack get();

    default public Icon setName(@Colorized String name) {
        return this.applyToMeta(meta -> meta.setDisplayName(Utils.colorize(name)));
    }

    default public Icon setMaterial(Material material) {
        this.get().setType(material);
        return this;
    }

    default public Icon hideAttributes() {
        return this.applyToMeta(meta -> {
            this.addDummyAttributeModifier((ItemMeta)meta);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        });
    }

    default public Icon hidePotionEffects() {
        return this.applyToMeta(meta -> {
            this.addDummyAttributeModifier((ItemMeta)meta);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
        });
    }

    default public Icon hideAllAttributes() {
        return this.applyToMeta(meta -> {
            this.addDummyAttributeModifier((ItemMeta)meta);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_POTION_EFFECTS, ItemFlag.HIDE_ARMOR_TRIM, ItemFlag.HIDE_PLACED_ON, ItemFlag.HIDE_DESTROYS, ItemFlag.HIDE_DYE, ItemFlag.HIDE_UNBREAKABLE});
        });
    }

    private void addDummyAttributeModifier(ItemMeta meta) {
        meta.addAttributeModifier(Attribute.GENERIC_MAX_HEALTH, new AttributeModifier("clickgui.hide_attributes", 0.0, AttributeModifier.Operation.ADD_NUMBER));
    }

    default public Icon addEnchantmentGlint() {
        return this.applyToMeta(meta -> {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            meta.addEnchant(Enchantment.DURABILITY, 1, true);
        });
    }

    default public Icon setLore(String ... lore) {
        return this.setLore(List.of(lore));
    }

    default public Icon setLore(@Colorized List<String> lore) {
        return this.applyToMeta(meta -> meta.setLore(lore.stream().map(Utils::colorize).toList()));
    }

    default public Icon addLoreLine(@Colorized String line) {
        return this.applyToMeta(meta -> {
            ArrayList<String> lore = meta.getLore();
            if (lore == null) {
                lore = new ArrayList<String>();
            }
            lore.add(Utils.colorize(line));
            meta.setLore(lore);
        });
    }

    default public Icon applyToMeta(Consumer<ItemMeta> consumer) {
        ItemMeta meta = this.get().getItemMeta();
        if (meta == null) {
            return this;
        }
        consumer.accept(meta);
        this.get().setItemMeta(meta);
        return this;
    }

    default public Icon runIf(boolean condition, Consumer<Icon> consumer) {
        if (condition) {
            consumer.accept(this);
        }
        return this;
    }

    public static Icon empty() {
        return Icon.of(Material.AIR);
    }

    public static Icon of(ItemStack item) {
        ItemStack copy = item.clone();
        return () -> copy;
    }

    public static Icon of(Material material) {
        ItemStack item = new ItemStack(material);
        return () -> item;
    }

    public static Icon of(Supplier<Icon> iconSupplier) {
        return () -> ((Icon)iconSupplier.get()).get();
    }
}

