/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickgui.menu;

import de.clickism.clickgui.menu.ClickAction;
import de.clickism.clickgui.menu.Colorized;
import de.clickism.clickgui.menu.Icon;
import de.clickism.clickgui.menu.MenuView;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Button {
    protected Icon icon;
    protected boolean immovable = true;
    protected BiConsumer<InventoryClickEvent, MenuView> onClick = (event, view) -> {};

    protected Button(Icon icon) {
        this.icon = icon;
    }

    protected void handleClick(InventoryClickEvent event, MenuView view) {
        event.setCancelled(this.immovable);
        this.onClick.accept(event, view);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public Button setName(@Colorized String name) {
        this.icon.setName(name);
        return this;
    }

    public Button setMaterial(Material material) {
        this.icon.setMaterial(material);
        return this;
    }

    public Button hideAttributes() {
        this.icon.hideAttributes();
        return this;
    }

    public Button hidePotionEffects() {
        this.icon.hidePotionEffects();
        return this;
    }

    public Button hideAllAttributes() {
        this.icon.hideAllAttributes();
        return this;
    }

    public Button addEnchantmentGlint() {
        this.icon.addEnchantmentGlint();
        return this;
    }

    public Button setLore(String ... lore) {
        this.icon.setLore(lore);
        return this;
    }

    public Button setLore(@Colorized List<String> lore) {
        this.icon.setLore(lore);
        return this;
    }

    public Button addLoreLine(@Colorized String line) {
        this.icon.addLoreLine(line);
        return this;
    }

    public Button runIf(boolean condition, Consumer<Button> consumer) {
        if (condition) {
            consumer.accept(this);
        }
        return this;
    }

    public Button setOnClick(ClickAction action) {
        this.onClick = (event, view) -> action.onClick(view.getMenu().getPlayer(), (MenuView)view, event.getRawSlot());
        return this;
    }

    public Button setOnClick(Consumer<InventoryClickEvent> eventConsumer) {
        this.onClick = (event, view) -> eventConsumer.accept((InventoryClickEvent)event);
        return this;
    }

    public Button setMovable() {
        this.immovable = false;
        return this;
    }

    public Button applyToMeta(Consumer<ItemMeta> consumer) {
        this.icon.applyToMeta(consumer);
        return this;
    }

    public static Button empty() {
        return Button.withIcon(Material.AIR);
    }

    public static Button withIcon(Icon icon) {
        return new Button(icon);
    }

    public static Button withIcon(ItemStack item) {
        return new Button(Icon.of(item));
    }

    public static Button withIcon(Material material) {
        return new Button(Icon.of(material));
    }

    public static Button withIcon(Supplier<Icon> iconSupplier) {
        return new Button(Icon.of(iconSupplier));
    }
}

