package de.clashsoft.gentreesrc.tree.decl;

import de.clashsoft.gentreesrc.tree.Node;
import java.util.List;


public interface TypeDecl extends Decl
{
	// =============== Static Methods ===============
	static TypeDecl of(boolean isAbstract, String packageName, String className, TypeDecl superType, List<PropertyDecl> properties, List<TypeDecl> subTypes) { return new Impl(isAbstract, packageName, className, superType, properties, subTypes); }

	// =============== Properties ===============
	boolean getIsAbstract();
	void setIsAbstract(boolean isAbstract);
	String getPackageName();
	void setPackageName(String packageName);
	String getClassName();
	void setClassName(String className);
	TypeDecl getSuperType();
	void setSuperType(TypeDecl superType);
	List<PropertyDecl> getProperties();
	void setProperties(List<PropertyDecl> properties);
	List<TypeDecl> getSubTypes();
	void setSubTypes(List<TypeDecl> subTypes);

	// =============== Methods ===============
	<P, R> R accept(TypeDecl.Visitor<P, R> visitor, P par);

	// =============== Classes ===============
	class Impl extends Decl.Impl implements TypeDecl
	{
		// =============== Fields ===============
		private boolean isAbstract;
		private String packageName;
		private String className;
		private TypeDecl superType;
		private List<PropertyDecl> properties;
		private List<TypeDecl> subTypes;

		// =============== Constructors ===============
		public Impl() {}
		public Impl(boolean isAbstract, String packageName, String className, TypeDecl superType, List<PropertyDecl> properties, List<TypeDecl> subTypes)
		{
			this.isAbstract = isAbstract;
			this.packageName = packageName;
			this.className = className;
			this.superType = superType;
			this.properties = properties;
			this.subTypes = subTypes;
		}

		// =============== Properties ===============
		@Override public boolean getIsAbstract() { return this.isAbstract; }
		@Override public void setIsAbstract(boolean isAbstract) { this.isAbstract = isAbstract; }
		@Override public String getPackageName() { return this.packageName; }
		@Override public void setPackageName(String packageName) { this.packageName = packageName; }
		@Override public String getClassName() { return this.className; }
		@Override public void setClassName(String className) { this.className = className; }
		@Override public TypeDecl getSuperType() { return this.superType; }
		@Override public void setSuperType(TypeDecl superType) { this.superType = superType; }
		@Override public List<PropertyDecl> getProperties() { return this.properties; }
		@Override public void setProperties(List<PropertyDecl> properties) { this.properties = properties; }
		@Override public List<TypeDecl> getSubTypes() { return this.subTypes; }
		@Override public void setSubTypes(List<TypeDecl> subTypes) { this.subTypes = subTypes; }

		// =============== Methods ===============
		@Override public <P, R> R accept(TypeDecl.Visitor<P, R> visitor, P par) { return visitor.visitTypeDecl(this, par); }
		@Override public <P, R> R accept(Decl.Visitor<P, R> visitor, P par) { return visitor.visitTypeDecl(this, par); }
		@Override public <P, R> R accept(Node.Visitor<P, R> visitor, P par) { return visitor.visitTypeDecl(this, par); }

	}

	interface Visitor<P, R>
	{
		// =============== Methods ===============
		R visitTypeDecl(TypeDecl TypeDecl, P par);
	}
}
