package de.clashsoft.gentreesrc.tree.decl;

import de.clashsoft.gentreesrc.tree.Node;


public interface Decl extends Node
{
	// =============== Static Methods ===============
	static Decl of() { return new Impl(); }

	// =============== Methods ===============
	<P, R> R accept(Decl.Visitor<P, R> visitor, P par);

	// =============== Classes ===============
	class Impl extends Node.Impl implements Decl
	{
		// =============== Methods ===============
		@Override public <P, R> R accept(Decl.Visitor<P, R> visitor, P par) { return visitor.visitDecl(this, par); }
		@Override public <P, R> R accept(Node.Visitor<P, R> visitor, P par) { return visitor.visitDecl(this, par); }

	}

	interface Visitor<P, R> extends ImportDecl.Visitor<P, R>, PropertyDecl.Visitor<P, R>, TypeDecl.Visitor<P, R>
	{
		// =============== Methods ===============
		R visitDecl(Decl Decl, P par);
	}
}
