package de.clashsoft.gentreesrc.tree;

import de.clashsoft.gentreesrc.tree.decl.ImportDecl;
import de.clashsoft.gentreesrc.tree.decl.TypeDecl;
import java.util.List;


public interface DefinitionFile extends Node
{
	// =============== Static Methods ===============
	static DefinitionFile of(List<ImportDecl> imports, List<TypeDecl> declarations) { return new Impl(imports, declarations); }

	// =============== Properties ===============
	List<ImportDecl> getImports();
	void setImports(List<ImportDecl> imports);
	List<TypeDecl> getDeclarations();
	void setDeclarations(List<TypeDecl> declarations);

	// =============== Methods ===============
	<P, R> R accept(DefinitionFile.Visitor<P, R> visitor, P par);

	// =============== Classes ===============
	class Impl extends Node.Impl implements DefinitionFile
	{
		// =============== Fields ===============
		private List<ImportDecl> imports;
		private List<TypeDecl> declarations;

		// =============== Constructors ===============
		public Impl() {}
		public Impl(List<ImportDecl> imports, List<TypeDecl> declarations)
		{
			this.imports = imports;
			this.declarations = declarations;
		}

		// =============== Properties ===============
		@Override public List<ImportDecl> getImports() { return this.imports; }
		@Override public void setImports(List<ImportDecl> imports) { this.imports = imports; }
		@Override public List<TypeDecl> getDeclarations() { return this.declarations; }
		@Override public void setDeclarations(List<TypeDecl> declarations) { this.declarations = declarations; }

		// =============== Methods ===============
		@Override public <P, R> R accept(DefinitionFile.Visitor<P, R> visitor, P par) { return visitor.visitDefinitionFile(this, par); }
		@Override public <P, R> R accept(Node.Visitor<P, R> visitor, P par) { return visitor.visitDefinitionFile(this, par); }

	}

	interface Visitor<P, R>
	{
		// =============== Methods ===============
		R visitDefinitionFile(DefinitionFile DefinitionFile, P par);
	}
}
