/*
 * Decompiled with CFR 0.152.
 */
package de.clashsoft.gentreesrc.util;

import de.clashsoft.gentreesrc.tree.DefinitionFile;
import de.clashsoft.gentreesrc.tree.Import;
import de.clashsoft.gentreesrc.tree.Property;
import de.clashsoft.gentreesrc.tree.TypeDeclaration;
import de.clashsoft.gentreesrc.tree.type.ListType;
import de.clashsoft.gentreesrc.tree.type.NamedType;
import de.clashsoft.gentreesrc.tree.type.OptionalType;
import de.clashsoft.gentreesrc.tree.type.Type;
import java.util.Map;
import java.util.Set;

public class ImportHelper {
    public static void collectImportMap(DefinitionFile definitionFile, Map<String, String> importMap) {
        for (Import import_ : definitionFile.getImports()) {
            importMap.put(import_.getTypeName(), import_.getPackageName());
        }
        for (TypeDeclaration decl : definitionFile.getDeclarations()) {
            ImportHelper.collectImportMap(decl, importMap);
        }
    }

    public static void collectImportMap(TypeDeclaration decl, Map<String, String> importMap) {
        importMap.put(decl.getClassName(), decl.getPackageName());
        for (TypeDeclaration subType : decl.getSubTypes()) {
            ImportHelper.collectImportMap(subType, importMap);
        }
    }

    public static void collectImports(Map<String, String> importMap, TypeDeclaration decl, Set<String> imports) {
        for (TypeDeclaration superType = decl.getSuperType(); superType != null; superType = superType.getSuperType()) {
            ImportHelper.addImport(decl, imports, superType);
        }
        ImportHelper.collectImportsRecursively(importMap, decl, imports, decl);
    }

    private static void collectImportsRecursively(Map<String, String> importMap, TypeDeclaration decl, Set<String> imports, TypeDeclaration current) {
        ImportHelper.addImport(decl, imports, current);
        for (Property property : decl.getProperties()) {
            ImportHelper.addImport(importMap, decl, imports, property.getType());
        }
        for (TypeDeclaration subType : current.getSubTypes()) {
            ImportHelper.collectImportsRecursively(importMap, decl, imports, subType);
        }
    }

    private static void addImport(final Map<String, String> importMap, final TypeDeclaration decl, final Set<String> imports, Type type) {
        type.accept(new Type.Visitor<Void, Void>(){

            @Override
            public Void visitType(Type type, Void par) {
                return null;
            }

            @Override
            public Void visitNamedType(NamedType namedType, Void par) {
                ImportHelper.addImport((Map<String, String>)importMap, decl, (Set<String>)imports, namedType.getName());
                return null;
            }

            @Override
            public Void visitListType(ListType listType, Void par) {
                imports.add("java.util.List");
                return listType.getElementType().accept(this, par);
            }

            @Override
            public Void visitOptionalType(OptionalType optionalType, Void par) {
                return optionalType.getWrappedType().accept(this, par);
            }
        }, null);
    }

    private static void addImport(Map<String, String> importMap, TypeDeclaration decl, Set<String> imports, String className) {
        String packageName = importMap.get(className);
        if (packageName != null && !packageName.equals(decl.getPackageName())) {
            imports.add(ImportHelper.getFullName(packageName, className));
        }
    }

    private static void addImport(TypeDeclaration decl, Set<String> imports, TypeDeclaration target) {
        if (!ImportHelper.packageEquals(decl, target)) {
            imports.add(ImportHelper.getFullName(target));
        }
    }

    private static boolean packageEquals(TypeDeclaration a, TypeDeclaration b) {
        return a == b || a.getPackageName().equals(b.getPackageName());
    }

    private static String getFullName(TypeDeclaration target) {
        return ImportHelper.getFullName(target.getPackageName(), target.getClassName());
    }

    private static String getFullName(String packageName, String className) {
        return packageName.isEmpty() ? className : packageName + "." + className;
    }
}

