/*
 * Decompiled with CFR 0.152.
 */
package de.clashsoft.gentreesrc;

import de.clashsoft.gentreesrc.tree.DefinitionFile;
import de.clashsoft.gentreesrc.tree.TypeDeclaration;
import de.clashsoft.gentreesrc.util.GTSStringRenderer;
import de.clashsoft.gentreesrc.util.ImportHelper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.stringtemplate.v4.AttributeRenderer;
import org.stringtemplate.v4.AutoIndentWriter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;
import org.stringtemplate.v4.STWriter;

public class Generator {
    private final String targetDirectory;
    private final Map<String, String> importMap;
    private final STGroup treeGroup;

    private Generator(String targetDirectory, Map<String, String> importMap, STGroup treeGroup) {
        this.targetDirectory = targetDirectory;
        this.importMap = importMap;
        this.treeGroup = treeGroup;
    }

    public static void generate(DefinitionFile definitionFile, String targetDirectory, String language) throws IOException {
        STGroupFile treeGroup = new STGroupFile(Generator.class.getResource("templates/" + language + ".stg"));
        treeGroup.registerRenderer(String.class, (AttributeRenderer)new GTSStringRenderer());
        HashMap<String, String> importMap = new HashMap<String, String>();
        ImportHelper.collectImportMap(definitionFile, importMap);
        Generator generator = new Generator(targetDirectory, importMap, (STGroup)treeGroup);
        for (TypeDeclaration decl : definitionFile.getDeclarations()) {
            generator.generate(decl);
        }
    }

    private void generate(TypeDeclaration decl) throws IOException {
        for (TypeDeclaration subDecl : decl.getSubTypes()) {
            this.generate(subDecl);
        }
        TreeSet<String> imports = new TreeSet<String>();
        ImportHelper.collectImports(this.importMap, decl, imports);
        String fileName = this.treeGroup.getInstanceOf("fileName").add("typeDecl", (Object)decl).render();
        File file = new File(this.targetDirectory, fileName);
        file.getParentFile().mkdirs();
        ST treeClass = this.treeGroup.getInstanceOf("treeClass");
        treeClass.add("typeDecl", (Object)decl);
        treeClass.add("imports", imports);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            treeClass.write((STWriter)new AutoIndentWriter((Writer)writer));
        }
    }
}

