/*
 * Decompiled with CFR 0.152.
 */
package de.clashsoft.gentreesrc.tool;

import de.clashsoft.gentreesrc.Generator;
import de.clashsoft.gentreesrc.Parser;
import de.clashsoft.gentreesrc.tool.Config;
import de.clashsoft.gentreesrc.tree.DefinitionFile;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.SourceVersion;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Tool
implements javax.tools.Tool {
    private static final String TOOL_NAME = "gentreesrc";
    private static final String USAGE = "gentreesrc <options> <inputDirs...>";
    private static final String FILE_EXTENSION = ".gts";
    private static final String HEADER = "options:";
    private final Config config = new Config();
    private PrintWriter out;
    private PrintWriter err;

    public PrintWriter getOut() {
        return this.out;
    }

    public void setOut(PrintWriter out) {
        this.out = out;
    }

    public PrintWriter getErr() {
        return this.err;
    }

    public void setErr(PrintWriter err) {
        this.err = err;
    }

    @Override
    public Set<SourceVersion> getSourceVersions() {
        return Collections.singleton(SourceVersion.RELEASE_8);
    }

    @Override
    public int run(InputStream in, OutputStream out, OutputStream err, String ... arguments) {
        this.setOut(new PrintWriter(out));
        this.setErr(new PrintWriter(err));
        int result = this.run(arguments);
        this.getOut().flush();
        this.getErr().flush();
        return result;
    }

    private int run(String[] arguments) {
        CommandLine cmd;
        Options options = this.config.createOptions();
        DefaultParser parser = new DefaultParser();
        HelpFormatter formatter = new HelpFormatter();
        try {
            cmd = parser.parse(options, arguments);
        }
        catch (ParseException e) {
            this.getOut().println(e.getMessage());
            formatter.printHelp(this.getOut(), 80, USAGE, HEADER, options, 2, 1, "");
            return 1;
        }
        this.config.readOptions(cmd);
        return this.run();
    }

    private int run() {
        for (String inputDirName : this.config.getInputDirs()) {
            File inputFile = new File(inputDirName);
            if (!inputFile.exists()) continue;
            this.process(inputFile);
        }
        return 0;
    }

    private void process(File inputFile) {
        if (inputFile.isDirectory()) {
            for (File child : Objects.requireNonNull(inputFile.listFiles())) {
                this.process(child);
            }
            return;
        }
        if (inputFile.getName().endsWith(FILE_EXTENSION)) {
            this.processDefinition(inputFile);
        }
    }

    private void processDefinition(File inputFile) {
        try {
            DefinitionFile definitionFile = Parser.parse(inputFile.getAbsolutePath());
            Generator.generate(definitionFile, this.config.getOutputDir(), this.config.getLanguage());
        }
        catch (Exception e) {
            e.printStackTrace(this.err);
        }
    }
}

