/*
 * Decompiled with CFR 0.152.
 */
package de.clashsoft.gentreesrc.antlr;

import de.clashsoft.gentreesrc.antlr.GenTreeSrcBaseListener;
import de.clashsoft.gentreesrc.antlr.GenTreeSrcParser;
import de.clashsoft.gentreesrc.tree.DefinitionFile;
import de.clashsoft.gentreesrc.tree.Import;
import de.clashsoft.gentreesrc.tree.Property;
import de.clashsoft.gentreesrc.tree.TypeDeclaration;
import de.clashsoft.gentreesrc.tree.type.ListType;
import de.clashsoft.gentreesrc.tree.type.NamedType;
import de.clashsoft.gentreesrc.tree.type.OptionalType;
import de.clashsoft.gentreesrc.tree.type.Type;
import java.util.ArrayList;

public class ASTListener
extends GenTreeSrcBaseListener {
    private DefinitionFile definitionFile;
    private TypeDeclaration currentDeclaration;
    private Type type;

    public ASTListener(DefinitionFile definitionFile) {
        this.definitionFile = definitionFile;
    }

    @Override
    public void enterImportDeclaration(GenTreeSrcParser.ImportDeclarationContext ctx) {
        String packageName = ASTListener.getPackageName(ctx.packageName());
        String typeName = ctx.typeName.getText();
        Import import_ = Import.of(packageName, typeName);
        this.definitionFile.getImports().add(import_);
    }

    @Override
    public void enterTypeDeclaration(GenTreeSrcParser.TypeDeclarationContext ctx) {
        String packageName = ASTListener.getPackageName(ctx.packageName());
        String className = ctx.className.getText();
        TypeDeclaration parent = this.currentDeclaration;
        String fullPackageName = ASTListener.getPackageName(parent, packageName);
        this.currentDeclaration = TypeDeclaration.of(fullPackageName, className, parent, new ArrayList<Property>(), new ArrayList<TypeDeclaration>());
        if (parent != null) {
            parent.getSubTypes().add(this.currentDeclaration);
        } else {
            this.definitionFile.getDeclarations().add(this.currentDeclaration);
        }
    }

    private static String getPackageName(GenTreeSrcParser.PackageNameContext ctx) {
        String packageText = ctx.getText();
        return packageText.isEmpty() ? packageText : packageText.substring(0, packageText.length() - 1);
    }

    private static String getPackageName(TypeDeclaration parent, String child) {
        if (parent == null) {
            return child;
        }
        if (child.isEmpty()) {
            return parent.getPackageName();
        }
        return parent.getPackageName() + '.' + child;
    }

    @Override
    public void exitProperty(GenTreeSrcParser.PropertyContext ctx) {
        String name = ctx.name.getText();
        Property property = Property.of(name, this.type);
        this.currentDeclaration.getProperties().add(property);
    }

    @Override
    public void exitNamedType(GenTreeSrcParser.NamedTypeContext ctx) {
        String name = ctx.name.getText();
        this.type = NamedType.of(name);
    }

    @Override
    public void exitListType(GenTreeSrcParser.ListTypeContext ctx) {
        this.type = ListType.of(this.type);
    }

    @Override
    public void exitOptionalType(GenTreeSrcParser.OptionalTypeContext ctx) {
        this.type = OptionalType.of(this.type);
    }

    @Override
    public void exitTypeDeclaration(GenTreeSrcParser.TypeDeclarationContext ctx) {
        this.currentDeclaration = this.currentDeclaration.getSuperType();
    }
}

