/*
 * Decompiled with CFR 0.152.
 */
package de.clashsoft.gentreesrc.codegen;

import de.clashsoft.gentreesrc.tree.DefinitionFile;
import de.clashsoft.gentreesrc.tree.decl.PropertyDecl;
import de.clashsoft.gentreesrc.tree.decl.TypeDecl;
import de.clashsoft.gentreesrc.tree.type.ArrayType;
import de.clashsoft.gentreesrc.tree.type.ListType;
import de.clashsoft.gentreesrc.tree.type.MapType;
import de.clashsoft.gentreesrc.tree.type.NamedType;
import de.clashsoft.gentreesrc.tree.type.OptionalType;
import de.clashsoft.gentreesrc.tree.type.Type;
import java.util.Map;
import java.util.Set;

public class ImportHelper {
    public static void collectImportMap(DefinitionFile definitionFile, Map<String, String> importMap) {
        for (TypeDecl decl : definitionFile.getDeclarations()) {
            ImportHelper.collectImportMap(decl, importMap);
        }
    }

    public static void collectImportMap(TypeDecl decl, Map<String, String> importMap) {
        importMap.put(decl.getClassName(), decl.getPackageName());
        for (TypeDecl subType : decl.getSubTypes()) {
            ImportHelper.collectImportMap(subType, importMap);
        }
    }

    public static void collectImports(Map<String, String> importMap, TypeDecl decl, Set<String> imports) {
        for (TypeDecl superType = decl.getSuperType(); superType != null; superType = superType.getSuperType()) {
            ImportHelper.addImport(decl, imports, superType);
        }
        ImportHelper.collectImportsRecursively(importMap, decl, imports, decl);
    }

    private static void collectImportsRecursively(Map<String, String> importMap, TypeDecl decl, Set<String> imports, TypeDecl current) {
        ImportHelper.addImport(decl, imports, current);
        for (PropertyDecl property : decl.getProperties()) {
            ImportHelper.addImport(importMap, decl, imports, property.getType());
        }
        for (TypeDecl subType : current.getSubTypes()) {
            ImportHelper.collectImportsRecursively(importMap, decl, imports, subType);
        }
    }

    private static void addImport(final Map<String, String> importMap, final TypeDecl decl, final Set<String> imports, Type type) {
        type.accept(new Type.Visitor<Void, Void>(){

            @Override
            public Void visit(Type type, Void par) {
                return null;
            }

            @Override
            public Void visit(NamedType namedType, Void par) {
                ImportHelper.addImport((Map<String, String>)importMap, decl, (Set<String>)imports, namedType.getName());
                if (namedType.getArgs() != null) {
                    for (Type arg : namedType.getArgs()) {
                        arg.accept(this, par);
                    }
                }
                return null;
            }

            @Override
            public Void visit(ArrayType arrayType, Void par) {
                return arrayType.getElementType().accept(this, par);
            }

            @Override
            public Void visit(ListType listType, Void par) {
                imports.add("java.util.List");
                return listType.getElementType().accept(this, par);
            }

            @Override
            public Void visit(OptionalType optionalType, Void par) {
                return optionalType.getWrappedType().accept(this, par);
            }

            @Override
            public Void visit(MapType mapType, Void par) {
                imports.add("java.util.Map");
                mapType.getKeyType().accept(this, par);
                mapType.getValueType().accept(this, par);
                return null;
            }
        }, null);
    }

    private static void addImport(Map<String, String> importMap, TypeDecl decl, Set<String> imports, String className) {
        String packageName = importMap.get(className);
        if (packageName != null && !packageName.equals(decl.getPackageName())) {
            imports.add(ImportHelper.getFullName(packageName, className));
        }
    }

    private static void addImport(TypeDecl decl, Set<String> imports, TypeDecl target) {
        if (!ImportHelper.packageEquals(decl, target)) {
            imports.add(ImportHelper.getFullName(target));
        }
    }

    private static boolean packageEquals(TypeDecl a, TypeDecl b) {
        return a == b || a.getPackageName().equals(b.getPackageName());
    }

    private static String getFullName(TypeDecl target) {
        return ImportHelper.getFullName(target.getPackageName(), target.getClassName());
    }

    private static String getFullName(String packageName, String className) {
        return packageName.isEmpty() ? className : packageName + "." + className;
    }
}

