/*
 * Decompiled with CFR 0.152.
 */
package de.clashsoft.gentreesrc.codegen;

import de.clashsoft.gentreesrc.codegen.ImportHelper;
import de.clashsoft.gentreesrc.codegen.StringRenderer;
import de.clashsoft.gentreesrc.tool.Config;
import de.clashsoft.gentreesrc.tree.DefinitionFile;
import de.clashsoft.gentreesrc.tree.decl.TypeDecl;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.stringtemplate.v4.AttributeRenderer;
import org.stringtemplate.v4.AutoIndentWriter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;
import org.stringtemplate.v4.STWriter;

public class Generator {
    private final Config config;
    private final Map<String, String> importMap;
    private final STGroup treeGroup;

    private Generator(Config config, Map<String, String> importMap, STGroup treeGroup) {
        this.config = config;
        this.importMap = importMap;
        this.treeGroup = treeGroup;
    }

    public static void generate(Config config, DefinitionFile definitionFile, Set<File> generatedFiles) throws IOException {
        STGroupFile treeGroup = new STGroupFile(Generator.class.getResource(config.getLanguage() + ".stg"));
        treeGroup.registerRenderer(String.class, (AttributeRenderer)new StringRenderer());
        HashMap<String, String> importMap = new HashMap<String, String>();
        ImportHelper.collectImportMap(definitionFile, importMap);
        Generator generator = new Generator(config, importMap, (STGroup)treeGroup);
        for (TypeDecl decl : definitionFile.getDeclarations()) {
            generator.generate(decl, generatedFiles);
        }
    }

    private void generate(TypeDecl decl, Set<File> generatedFiles) throws IOException {
        for (TypeDecl subDecl : decl.getSubTypes()) {
            this.generate(subDecl, generatedFiles);
        }
        if (decl.getAttributes().isImport()) {
            return;
        }
        TreeSet<String> imports = new TreeSet<String>();
        ImportHelper.collectImports(this.importMap, decl, imports);
        String fileName = this.treeGroup.getInstanceOf("fileName").add("typeDecl", (Object)decl).render();
        File file = new File(this.config.getOutputDir(), fileName);
        file.getParentFile().mkdirs();
        ST treeClass = this.treeGroup.getInstanceOf("treeClass");
        treeClass.add("config", (Object)this.config);
        treeClass.add("typeDecl", (Object)decl);
        treeClass.add("imports", imports);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            treeClass.write((STWriter)new AutoIndentWriter((Writer)writer));
        }
        generatedFiles.add(file);
    }
}

