/*
 * Decompiled with CFR 0.152.
 */
package de.citec.scie.pdf.structure;

import de.citec.scie.pdf.structure.LineSegment;
import de.citec.scie.pdf.structure.Paragraph;
import java.util.ArrayList;
import java.util.Objects;

public class TextBlock
extends LineSegment {
    public final ArrayList<Paragraph> content = new ArrayList();
    private double relativeFontSize;

    public double getRelativeFontSize() {
        return this.relativeFontSize;
    }

    public void setRelativeFontSize(double relativeFontSize) {
        this.relativeFontSize = relativeFontSize;
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + Objects.hashCode(this.content);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextBlock other = (TextBlock)obj;
        return Objects.equals(this.content, other.content);
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < this.content.size(); ++i) {
            output.append('\t');
            output.append(this.content.get(i).toString());
            if (i >= this.content.size() - 1) continue;
            output.append("\n\n");
        }
        return output.toString();
    }

    public String indexedToString(int currentIdx) {
        this.setBegin(currentIdx);
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < this.content.size(); ++i) {
            output.append('\t');
            String parStr = this.content.get(i).indexedToString(++currentIdx);
            output.append(parStr);
            currentIdx += parStr.length();
            if (i >= this.content.size() - 1) continue;
            output.append("\n\n");
            currentIdx += 2;
        }
        this.setEnd(currentIdx);
        return output.toString();
    }

    public String toXML() {
        StringBuilder output = new StringBuilder();
        output.append("\t\t<TextBlock RELATIVE_FONT_SIZE=\"");
        output.append(Double.toString(this.relativeFontSize));
        output.append("\">\n");
        for (int i = 0; i < this.content.size(); ++i) {
            output.append(this.content.get(i).toXML());
            if (i >= this.content.size() - 1) continue;
            output.append("\n");
        }
        output.append("\n\t\t</TextBlock>");
        return output.toString();
    }
}

