/*
 * Decompiled with CFR 0.152.
 */
package de.citec.scie.pdf.structure;

import de.citec.scie.pdf.structure.LineSegment;
import java.util.Objects;

public class Text
extends LineSegment {
    private String text;
    private float fontSize;
    private VerticalAlignment verticalAlignment = VerticalAlignment.REGULAR;
    private String fontName;

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String toString() {
        return this.text;
    }

    public String indexedToString(int currentIdx) {
        this.setBegin(currentIdx);
        this.setEnd(currentIdx + this.text.length());
        return this.text;
    }

    public String toXML() {
        return "\t\t\t\t<Text fontSize=\"" + this.fontSize + "\" font=\"" + this.fontName + "\" vValign=\"" + (Object)((Object)this.verticalAlignment) + "\">" + this.text + "</Text>";
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + Objects.hashCode(this.text);
        hash = 31 * hash + Float.floatToIntBits(this.fontSize);
        hash = 31 * hash + (this.verticalAlignment != null ? this.verticalAlignment.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Text other = (Text)obj;
        if (!Objects.equals(this.text, other.text)) {
            return false;
        }
        if (this.fontSize != other.fontSize) {
            return false;
        }
        return this.verticalAlignment == other.verticalAlignment;
    }

    public static enum VerticalAlignment {
        SUPERSCRIPT,
        SUBSCRIPT,
        REGULAR;

    }
}

