/*
 * Decompiled with CFR 0.152.
 */
package de.citec.scie.pdf.structure;

import de.citec.scie.pdf.structure.LineSegment;
import de.citec.scie.pdf.structure.Text;
import java.util.ArrayList;
import java.util.Objects;

public class Paragraph
extends LineSegment {
    public final ArrayList<Text> content = new ArrayList();

    public int hashCode() {
        int hash = 5;
        hash = 61 * hash + Objects.hashCode(this.content);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Paragraph other = (Paragraph)obj;
        return Objects.equals(this.content, other.content);
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < this.content.size(); ++i) {
            output.append(this.content.get(i).toString());
            if (i >= this.content.size() - 1) continue;
            output.append(' ');
        }
        return output.toString();
    }

    public String indexedToString(int currentIdx) {
        this.setBegin(currentIdx);
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < this.content.size(); ++i) {
            String textStr = this.content.get(i).indexedToString(currentIdx);
            output.append(textStr);
            currentIdx += textStr.length();
            if (i >= this.content.size() - 1) continue;
            output.append(' ');
            ++currentIdx;
        }
        this.setEnd(currentIdx);
        return output.toString();
    }

    public String toXML() {
        StringBuilder output = new StringBuilder();
        output.append("\t\t\t<Paragraph>\n");
        for (int i = 0; i < this.content.size(); ++i) {
            output.append(this.content.get(i).toXML());
            if (i >= this.content.size() - 1) continue;
            output.append("\n");
        }
        output.append("\n\t\t\t</Paragraph>");
        return output.toString();
    }
}

