/*
 * Decompiled with CFR 0.152.
 */
package de.citec.scie.pdf.structure;

import de.citec.scie.pdf.structure.LineSegment;
import de.citec.scie.pdf.structure.TextBlock;
import java.util.ArrayList;
import java.util.Objects;

public class Page
extends LineSegment {
    public final ArrayList<TextBlock> content = new ArrayList();
    private int pageNumber;

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + Objects.hashCode(this.content);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Page other = (Page)obj;
        return Objects.equals(this.content, other.content);
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < this.content.size(); ++i) {
            output.append(this.content.get(i).toString());
            if (i >= this.content.size() - 1) continue;
            output.append("\n\n");
        }
        return output.toString();
    }

    public String indexedToString(int currentIdx) {
        this.setBegin(currentIdx);
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < this.content.size(); ++i) {
            String blockStr = this.content.get(i).indexedToString(currentIdx);
            output.append(blockStr);
            currentIdx += blockStr.length();
            if (i >= this.content.size() - 1) continue;
            output.append("\n\n");
            currentIdx += 2;
        }
        this.setEnd(currentIdx);
        return output.toString();
    }

    public String toXML() {
        StringBuilder output = new StringBuilder();
        output.append("\t<Page>\n");
        for (int i = 0; i < this.content.size(); ++i) {
            output.append(this.content.get(i).toXML());
            if (i >= this.content.size() - 1) continue;
            output.append("\n");
        }
        output.append("\n\t</Page>");
        return output.toString();
    }
}

