/*
 * Decompiled with CFR 0.152.
 */
package de.citec.scie.pdf.structure;

import de.citec.scie.pdf.structure.AbstractLineSegment;

public class LineSegment
implements AbstractLineSegment {
    protected int begin;
    protected int end;

    public static final boolean isValid(AbstractLineSegment line) {
        return line.getBegin() <= line.getEnd();
    }

    public static final int length(AbstractLineSegment line) {
        return Math.abs(line.getEnd() - line.getBegin());
    }

    public static final LineSegment normalize(AbstractLineSegment line) {
        if (!LineSegment.isValid(line)) {
            return new LineSegment(line.getEnd(), line.getBegin());
        }
        return new LineSegment(line.getBegin(), line.getEnd());
    }

    public static final int[] normalizedBounds(AbstractLineSegment line) {
        LineSegment l = LineSegment.normalize(line);
        return new int[]{l.getBegin(), l.getEnd()};
    }

    public static final LineSegment union(AbstractLineSegment l1, AbstractLineSegment l2) {
        int[] n1 = LineSegment.normalizedBounds(l1);
        int[] n2 = LineSegment.normalizedBounds(l2);
        return new LineSegment(Math.min(n1[0], n2[0]), Math.max(n1[1], n2[1]));
    }

    public static final LineSegment intersection(AbstractLineSegment l1, AbstractLineSegment l2) {
        int e;
        int[] n2;
        int[] n1 = LineSegment.normalizedBounds(l1);
        int b = Math.max(n1[0], (n2 = LineSegment.normalizedBounds(l2))[0]);
        if (b > (e = Math.min(n1[1], n2[1]))) {
            return null;
        }
        return new LineSegment(b, e);
    }

    public static final boolean boundariesEqual(AbstractLineSegment l1, AbstractLineSegment l2) {
        int[] n2;
        int[] n1 = LineSegment.normalizedBounds(l1);
        return n1[0] == (n2 = LineSegment.normalizedBounds(l2))[0] && n1[1] == n2[1];
    }

    public static final boolean overlaps(AbstractLineSegment l1, AbstractLineSegment l2) {
        int[] n2;
        int[] n1 = LineSegment.normalizedBounds(l1);
        return n1[0] >= (n2 = LineSegment.normalizedBounds(l2))[0] && n1[0] <= n2[1] || n2[0] >= n1[0] && n2[0] <= n1[1];
    }

    public LineSegment() {
        this(Integer.MAX_VALUE, Integer.MIN_VALUE);
    }

    public LineSegment(int begin, int end) {
        this.begin = begin;
        this.end = end;
    }

    @Override
    public final int getBegin() {
        return this.begin;
    }

    @Override
    public final int getEnd() {
        return this.end;
    }

    public final void setBegin(int begin) {
        this.begin = begin;
    }

    public final void setEnd(int end) {
        this.end = end;
    }

    public final boolean isValid() {
        return LineSegment.isValid(this);
    }

    public final boolean boundariesEqual(AbstractLineSegment l) {
        return LineSegment.boundariesEqual(this, l);
    }

    public final boolean overlaps(AbstractLineSegment l) {
        return LineSegment.overlaps(this, l);
    }

    public final void normalize() {
        if (!this.isValid()) {
            int tmp = this.end;
            this.end = this.begin;
            this.begin = tmp;
        }
    }

    public final int length() {
        return LineSegment.length(this);
    }
}

