/*
 * Decompiled with CFR 0.152.
 */
package de.citec.scie.pdf;

import org.apache.pdfbox.util.TextPosition;

public class WhiteSpaceEstimator {
    private static final float SPACINGTOL = 0.5f;
    private static final float AVGCHARTOL = 0.3f;
    private TextPosition lastPosition = null;
    private float prevAvgCharWidth = -1.0f;

    public boolean hasWhiteSpace(TextPosition position) {
        if (this.lastPosition == null) {
            this.lastPosition = position;
            float positionWidth = position.getWidthDirAdj();
            int wordCharCount = position.getIndividualWidths().length;
            this.prevAvgCharWidth = positionWidth / (float)wordCharCount;
            return false;
        }
        float positionWidth = position.getWidthDirAdj();
        float positionX = position.getXDirAdj();
        float endOfLastTextX = this.lastPosition.getXDirAdj() + this.lastPosition.getWidthDirAdj();
        float lastWordSpacing = this.lastPosition.getWidthOfSpace();
        int wordCharCount = position.getIndividualWidths().length;
        float wordSpacing = position.getWidthOfSpace();
        float deltaSpace = wordSpacing == 0.0f || wordSpacing == Float.NaN ? Float.MAX_VALUE : (lastWordSpacing < 0.0f ? wordSpacing * 0.5f : (wordSpacing + lastWordSpacing) / 2.0f * 0.5f);
        float averageCharWidth = this.prevAvgCharWidth < 0.0f ? positionWidth / (float)wordCharCount : (this.prevAvgCharWidth + positionWidth / (float)wordCharCount) / 2.0f;
        float deltaCharWidth = averageCharWidth * 0.3f;
        float expectedStartOfNextWordX = 0.0f;
        if (this.lastPosition != null) {
            expectedStartOfNextWordX = deltaCharWidth > deltaSpace ? endOfLastTextX + deltaSpace : endOfLastTextX + deltaCharWidth;
        }
        boolean hasWhitespace = false;
        if (expectedStartOfNextWordX < positionX && this.lastPosition.getCharacter() != null && !this.lastPosition.getCharacter().endsWith(" ")) {
            hasWhitespace = true;
        }
        this.lastPosition = position;
        this.prevAvgCharWidth = averageCharWidth;
        return hasWhitespace;
    }
}

