/*
 * Decompiled with CFR 0.152.
 */
package de.citec.scie.pdf;

import de.citec.scie.pdf.PreTextLine;
import de.citec.scie.pdf.structure.Text;
import org.apache.pdfbox.util.TextPosition;

public class VerticalAlignmentEstimator {
    private static final float YTOL = 0.1f;
    private final float lineY;

    public VerticalAlignmentEstimator(PreTextLine line) {
        this.lineY = line.yHisto.getMaxElement().floatValue();
    }

    public Text.VerticalAlignment calculateAlignment(TextPosition glyph) {
        float glyphHeight;
        float adjTol;
        float glyphY = glyph.getYDirAdj();
        if (glyphY > this.lineY + (adjTol = 0.1f * (glyphHeight = glyph.getHeightDir()))) {
            return Text.VerticalAlignment.SUBSCRIPT;
        }
        if (glyphY < this.lineY - adjTol) {
            return Text.VerticalAlignment.SUPERSCRIPT;
        }
        return Text.VerticalAlignment.REGULAR;
    }
}

