/*
 * Decompiled with CFR 0.152.
 */
package de.citec.scie.pdf;

import de.citec.scie.pdf.Histogramm;
import de.citec.scie.pdf.PreTextBlock;
import de.citec.scie.pdf.PreTextLine;
import de.citec.scie.pdf.structure.TextBlock;
import java.util.ArrayList;

public class TextBlockRankEstimator {
    private final Histogramm<Float> pageFontSizeHisto = new Histogramm();
    private final ArrayList<TextBlock> blocks = new ArrayList();
    private final ArrayList<Histogramm<Float>> blockFontSizeHistos = new ArrayList();

    public void addBlock(TextBlock block, PreTextBlock preTextBlock) {
        this.blocks.add(block);
        Histogramm<Float> blockFontSizeHisto = new Histogramm<Float>();
        for (PreTextLine line : preTextBlock.lines) {
            blockFontSizeHisto.addAll(line.fontSizeHisto);
        }
        this.blockFontSizeHistos.add(blockFontSizeHisto);
        this.pageFontSizeHisto.addAll(blockFontSizeHisto);
    }

    public double getRelativeFontSize(TextBlock block) {
        int blockIdx = this.blocks.indexOf(block);
        if (blockIdx == -1) {
            return -1.0;
        }
        Histogramm<Float> blockFontSizeHisto = this.blockFontSizeHistos.get(blockIdx);
        double blockFontSize = blockFontSizeHisto.getMaxElement().floatValue();
        double pageFontSize = this.pageFontSizeHisto.getMaxElement().floatValue();
        return blockFontSize / pageFontSize;
    }
}

