/*
 * Decompiled with CFR 0.152.
 */
package de.citec.scie.pdf;

public class StringSimilarity {
    public double calculate(String a, String b) {
        int i;
        char[] aContent = a.toCharArray();
        char[] bContent = b.toCharArray();
        int[][] alignMat = new int[aContent.length + 1][bContent.length + 1];
        for (int j = 1; j <= bContent.length; ++j) {
            alignMat[0][j] = alignMat[0][j - 1] + 1;
        }
        for (i = 1; i <= aContent.length; ++i) {
            alignMat[i][0] = alignMat[i - 1][0] + 1;
        }
        for (i = 1; i <= aContent.length; ++i) {
            for (int j = 1; j <= bContent.length; ++j) {
                int insertionScore = alignMat[i][j - 1] + 1;
                int deletionScore = alignMat[i - 1][j] + 1;
                int localRepScore = aContent[i - 1] == bContent[j - 1] ? 0 : (Character.isDigit(aContent[i - 1]) && Character.isDigit(bContent[j - 1]) ? 0 : 1);
                int replacementScore = alignMat[i - 1][j - 1] + localRepScore;
                alignMat[i][j] = Math.min(insertionScore, Math.min(deletionScore, replacementScore));
            }
        }
        double actualAlignDistance = alignMat[aContent.length][bContent.length];
        double worstCaseAlignDistance = Math.max(aContent.length, bContent.length);
        return 1.0 - actualAlignDistance / worstCaseAlignDistance;
    }
}

