/*
 * Decompiled with CFR 0.152.
 */
package de.citec.scie.pdf;

import de.citec.scie.pdf.Histogramm;
import java.util.ArrayList;
import org.apache.pdfbox.util.TextPosition;

public class PreTextLine {
    private float x_start;
    private float x_end;
    public final Histogramm<Float> yHisto = new Histogramm();
    public final Histogramm<Float> fontSizeHisto = new Histogramm();
    public final Histogramm<String> fontHisto = new Histogramm();
    public final ArrayList<TextPosition> content = new ArrayList();

    public void addElement(TextPosition pos) {
        if (this.content.isEmpty()) {
            this.x_start = pos.getXDirAdj();
        }
        this.content.add(pos);
        this.yHisto.addDataPoint(Float.valueOf(pos.getYDirAdj()));
        this.fontSizeHisto.addDataPoint(Float.valueOf(pos.getFontSizeInPt()));
        if (pos.getFont() != null && pos.getFont().getFontDescriptor() != null) {
            this.fontHisto.addDataPoint(pos.getFont().getFontDescriptor().getFontName());
        }
    }

    public float getX_start() {
        return this.x_start;
    }

    public float getX_end() {
        return this.x_end;
    }

    public void setX_End() {
        this.x_end = this.content.get(this.content.size() - 1).getXDirAdj();
    }

    public float length() {
        return this.x_end - this.x_start;
    }

    public boolean isPartOfLine(TextPosition pos) {
        if (this.content.isEmpty()) {
            return true;
        }
        TextPosition lastPos = this.content.get(this.content.size() - 1);
        float oldXPos = lastPos.getXDirAdj();
        float newXPos = pos.getXDirAdj();
        if (newXPos + pos.getWidthDirAdj() < oldXPos) {
            return false;
        }
        float oldYStart = lastPos.getYDirAdj();
        float oldHeight = lastPos.getHeightDir();
        float newY = pos.getYDirAdj();
        return !(newY < oldYStart - oldHeight) && !(newY > oldYStart + 2.0f * oldHeight);
    }
}

