/*
 * Decompiled with CFR 0.152.
 */
package de.citec.scie.pdf;

import de.citec.scie.pdf.Histogramm;
import de.citec.scie.pdf.PreTextLine;
import java.util.ArrayDeque;
import java.util.ArrayList;
import org.apache.pdfbox.util.TextPosition;

public class PreTextBlock {
    public final ArrayList<PreTextLine> lines = new ArrayList();
    public final Histogramm<Float> yDistHisto = new Histogramm();
    public final Histogramm<Float> lengthHisto = new Histogramm();
    private static final float YTOL = 3.0f;
    public static final int MINIMUMBLOCKSIZE = 150;

    public int getSize() {
        int size = 0;
        for (PreTextLine line : this.lines) {
            size += line.content.size();
        }
        return size;
    }

    public void addTextPosition(TextPosition text) {
        PreTextLine line;
        if (this.lines.isEmpty()) {
            line = new PreTextLine();
            this.lines.add(line);
        } else {
            line = this.lines.get(this.lines.size() - 1);
            if (!line.isPartOfLine(text)) {
                if (this.lines.size() > 1) {
                    PreTextLine lastLine = this.lines.get(this.lines.size() - 2);
                    float lastLineY = lastLine.yHisto.getMaxElement().floatValue();
                    float lineY = line.yHisto.getMaxElement().floatValue();
                    float lineYDist = lineY - lastLineY;
                    this.yDistHisto.addDataPoint(Float.valueOf(lineYDist));
                }
                line.setX_End();
                line = new PreTextLine();
                this.lines.add(line);
            }
        }
        this.lengthHisto.addDataPoint(Float.valueOf(line.length()));
        line.addElement(text);
    }

    public void addLine(PreTextLine line) {
        this.lengthHisto.addDataPoint(Float.valueOf(line.length()));
        if (!this.lines.isEmpty()) {
            PreTextLine lastLine = this.lines.get(this.lines.size() - 1);
            float lastLineY = lastLine.yHisto.getMaxElement().floatValue();
            float lineY = line.yHisto.getMaxElement().floatValue();
            float lineYDist = lineY - lastLineY;
            this.yDistHisto.addDataPoint(Float.valueOf(lineYDist));
        }
        this.lines.add(line);
    }

    public ArrayList<PreTextBlock> split() {
        String referenceFont;
        if (this.lines.isEmpty()) {
            return new ArrayList<PreTextBlock>();
        }
        PreTextBlock newBlock = new PreTextBlock();
        ArrayDeque<PreTextBlock> fontSplit = new ArrayDeque<PreTextBlock>();
        if (!this.lines.get((int)0).fontHisto.getBackingMap().isEmpty() && (referenceFont = this.lines.get((int)0).fontHisto.getMaxElement()) != null) {
            for (PreTextLine preTextLine : this.lines) {
                String currentFont;
                if (!preTextLine.fontHisto.getBackingMap().isEmpty() && !(currentFont = preTextLine.fontHisto.getMaxElement()).equals(referenceFont)) {
                    fontSplit.add(newBlock);
                    newBlock = new PreTextBlock();
                    referenceFont = currentFont;
                }
                newBlock.addLine(preTextLine);
            }
            fontSplit.add(newBlock);
        }
        ArrayDeque<PreTextBlock> fontSizeSplit = new ArrayDeque<PreTextBlock>();
        if (!this.lines.get((int)0).fontSizeHisto.getBackingMap().isEmpty()) {
            float referenceFontSize = this.lines.get((int)0).fontSizeHisto.getMaxElement().floatValue();
            newBlock = new PreTextBlock();
            for (PreTextLine line : this.lines) {
                float currentFontSize;
                if (!line.fontSizeHisto.getBackingMap().isEmpty() && (currentFontSize = line.fontSizeHisto.getMaxElement().floatValue()) != referenceFontSize) {
                    fontSizeSplit.add(newBlock);
                    newBlock = new PreTextBlock();
                    referenceFontSize = currentFontSize;
                }
                newBlock.addLine(line);
            }
            fontSizeSplit.add(newBlock);
        }
        ArrayDeque<PreTextBlock> gapSplit = new ArrayDeque<PreTextBlock>();
        if (!this.yDistHisto.getBackingMap().isEmpty()) {
            float f = this.yDistHisto.getMaxElement().floatValue();
            float lastY = this.lines.get((int)0).yHisto.getMaxElement().floatValue();
            newBlock = new PreTextBlock();
            newBlock.addLine(this.lines.get(0));
            for (int i = 1; i < this.lines.size(); ++i) {
                float currentY = this.lines.get((int)i).yHisto.getMaxElement().floatValue();
                float currentGap = currentY - lastY;
                if (currentGap > 3.0f * f || f > 3.0f * currentGap) {
                    gapSplit.add(newBlock);
                    newBlock = new PreTextBlock();
                }
                newBlock.addLine(this.lines.get(i));
                lastY = currentY;
            }
            gapSplit.add(newBlock);
        }
        ArrayList<PreTextBlock> arrayList = new ArrayList<PreTextBlock>();
        int currentLine = 0;
        ArrayList<ArrayDeque<PreTextBlock>> splits = new ArrayList<ArrayDeque<PreTextBlock>>();
        ArrayList<Integer> startLines = new ArrayList<Integer>();
        int totalSize = this.getSize();
        if (this.isSaneSplitSuggestion(fontSplit, totalSize)) {
            splits.add(fontSplit);
            startLines.add(0);
        }
        if (this.isSaneSplitSuggestion(fontSizeSplit, totalSize)) {
            splits.add(fontSizeSplit);
            startLines.add(0);
        }
        if (this.isSaneSplitSuggestion(gapSplit, totalSize)) {
            splits.add(gapSplit);
            startLines.add(0);
        }
        if (!splits.isEmpty()) {
            while (currentLine < this.lines.size()) {
                int i;
                int minSize = Integer.MAX_VALUE;
                PreTextBlock minBlock = null;
                for (i = 0; i < splits.size(); ++i) {
                    PreTextBlock currentBlockSuggestion;
                    int start;
                    if (((ArrayDeque)splits.get(i)).isEmpty() || (start = ((Integer)startLines.get(i)).intValue()) != currentLine || (currentBlockSuggestion = (PreTextBlock)((ArrayDeque)splits.get(i)).peekFirst()) == null || currentBlockSuggestion.lines.size() >= minSize) continue;
                    minSize = currentBlockSuggestion.lines.size();
                    minBlock = currentBlockSuggestion;
                }
                arrayList.add(minBlock);
                currentLine += minSize;
                for (i = 0; i < splits.size(); ++i) {
                    int currentStart;
                    PreTextBlock block;
                    for (currentStart = ((Integer)startLines.get(i)).intValue(); currentStart < currentLine && !((ArrayDeque)splits.get(i)).isEmpty(); currentStart += block.lines.size()) {
                        block = (PreTextBlock)((ArrayDeque)splits.get(i)).poll();
                    }
                    startLines.set(i, currentStart);
                }
            }
        }
        if (arrayList.isEmpty()) {
            arrayList.add(this);
        }
        return arrayList;
    }

    private boolean isSaneSplitSuggestion(ArrayDeque<PreTextBlock> splitSuggestion, int referenceSize) {
        if (splitSuggestion.size() < 2) {
            return false;
        }
        double avgSplitSize = (double)referenceSize / (double)splitSuggestion.size();
        return avgSplitSize >= 150.0;
    }
}

